/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory.ui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.directory.api.ui.DirectoryUI;
import org.nuxeo.ecm.directory.api.ui.DirectoryUIDescriptor;
import org.nuxeo.ecm.directory.api.ui.DirectoryUIManager;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryUIManagerImpl
extends DefaultComponent
implements DirectoryUIManager {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(DirectoryUIManagerImpl.class);
    protected static final String DIRECTORIES_EP_NAME = "directories";
    protected Map<String, DirectoryUI> registry;

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.isAssignableFrom(DirectoryUIManager.class)) {
            return (T)this;
        }
        return null;
    }

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
        this.registry = new LinkedHashMap<String, DirectoryUI>();
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.registry = null;
        super.deactivate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (!extensionPoint.equals(DIRECTORIES_EP_NAME)) {
            log.warn((Object)("Unknown extension point: " + extensionPoint));
            return;
        }
        DirectoryUIDescriptor desc = (DirectoryUIDescriptor)contribution;
        String name = desc.getName();
        boolean disabled = Boolean.FALSE.equals(desc.isEnabled());
        if (this.registry.containsKey(name)) {
            log.info((Object)("Overriding " + name));
        }
        if (disabled) {
            this.registry.remove(name);
        } else {
            this.registry.put(name, desc);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (!extensionPoint.equals(DIRECTORIES_EP_NAME)) {
            log.warn((Object)("Unknown extension point: " + extensionPoint));
            return;
        }
        DirectoryUIDescriptor desc = (DirectoryUIDescriptor)contribution;
        this.registry.remove(desc.getName());
    }

    @Override
    public DirectoryUI getDirectoryInfo(String directoryName) throws ClientException {
        return this.registry.get(directoryName);
    }

    @Override
    public List<String> getDirectoryNames() throws ClientException {
        return new ArrayList<String>(this.registry.keySet());
    }
}

