/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.action;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.action.ActionContextProvider;
import org.nuxeo.ecm.webapp.action.WebActionsLocal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="webActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class WebActionsBean
implements WebActionsLocal,
Serializable {
    private static final long serialVersionUID = 1959221536502251848L;
    private static final Log log = LogFactory.getLog(WebActionsBean.class);
    @In(create=true, required=false)
    protected transient ActionManager actionManager;
    @In(create=true, required=false)
    protected transient ActionContextProvider actionContextProvider;
    @In(create=true, required=false)
    protected transient NavigationContext navigationContext;
    protected List<Action> tabsActionsList;
    protected List<Action> subTabsActionsList;
    @Out(required=false)
    protected Action currentTabAction;
    @Out(required=false)
    protected Action currentSubTabAction;

    @Override
    public void initialize() {
        log.debug((Object)"Initializing...");
    }

    @Override
    @Destroy
    public void destroy() {
        log.debug((Object)"Removing Seam action listener...");
    }

    @Override
    @PrePassivate
    public void saveState() {
        log.debug((Object)"PrePassivate");
    }

    @Override
    @PostActivate
    public void readState() {
        log.debug((Object)"PostActivate");
    }

    public List<Action> getActionsList(String category, ActionContext context) {
        ArrayList<Action> list = new ArrayList<Action>();
        List actions = this.actionManager.getActions(category, context);
        if (actions != null) {
            list.addAll(actions);
        }
        return list;
    }

    public List<Action> getActionsList(String category) {
        return this.getActionsList(category, this.createActionContext());
    }

    public List<Action> getUnfiltredActionsList(String category, ActionContext context) {
        ArrayList<Action> list = new ArrayList<Action>();
        List actions = this.actionManager.getActions(category, context, false);
        if (actions != null) {
            list.addAll(actions);
        }
        return list;
    }

    public List<Action> getUnfiltredActionsList(String category) {
        return this.getUnfiltredActionsList(category, this.createActionContext());
    }

    public List<Action> getAllActions(String category) {
        return this.actionManager.getAllActions(category);
    }

    protected ActionContext createActionContext() {
        return this.actionContextProvider.createActionContext();
    }

    @Deprecated
    public List<Action> getSubViewActionsList() {
        return this.getActionsList("SUBVIEW_UPPER_LIST");
    }

    @Observer(value={"userAllDocumentTypesSelectionChanged", "locationSelectionChanged"}, create=false, inject=false)
    @BypassInterceptors
    public void resetTabList() {
        this.tabsActionsList = null;
        this.currentTabAction = null;
        this.subTabsActionsList = null;
        this.currentSubTabAction = null;
    }

    public void resetCurrentTab() {
        this.currentTabAction = null;
        this.currentSubTabAction = null;
    }

    @Factory(value="tabsActionsList", scope=ScopeType.EVENT)
    public List<Action> getTabsList() {
        if (this.tabsActionsList == null) {
            this.tabsActionsList = this.getActionsList("VIEW_ACTION_LIST");
            this.currentTabAction = this.getDefaultTab();
        }
        return this.tabsActionsList;
    }

    @Factory(value="subTabsActionsList", scope=ScopeType.EVENT)
    public List<Action> getSubTabsList() {
        String currentTabId;
        if (this.subTabsActionsList == null && (currentTabId = this.getCurrentTabId()) != null) {
            String category = currentTabId + "_sub_tab";
            this.subTabsActionsList = this.getActionsList(category);
            this.currentSubTabAction = this.getDefaultSubTab();
        }
        return this.subTabsActionsList;
    }

    public void setTabsList(List<Action> tabsList) {
        this.tabsActionsList = tabsList;
    }

    public void setSubTabsList(List<Action> tabsList) {
        this.subTabsActionsList = tabsList;
    }

    protected Action getDefaultTab() {
        if (this.getTabsList() == null) {
            return null;
        }
        try {
            return this.tabsActionsList.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Action getCurrentTabAction() {
        if (this.currentTabAction == null) {
            this.currentTabAction = this.getDefaultTab();
        }
        return this.currentTabAction;
    }

    public void setCurrentTabAction(Action currentTabAction) {
        this.currentTabAction = currentTabAction;
        this.subTabsActionsList = null;
        this.currentSubTabAction = null;
    }

    protected Action getDefaultSubTab() {
        if (this.getSubTabsList() == null) {
            return null;
        }
        try {
            return this.subTabsActionsList.get(0);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    public Action getCurrentSubTabAction() {
        if (this.currentSubTabAction == null) {
            this.currentSubTabAction = this.getDefaultSubTab();
        }
        return this.currentSubTabAction;
    }

    public void setCurrentSubTabAction(Action tabAction) {
        this.currentSubTabAction = tabAction;
    }

    @Deprecated
    public void setCurrentTabAction(String currentTabActionId) {
        this.setCurrentTabId(currentTabActionId);
    }

    public String getCurrentTabId() {
        Action currentTab = this.getCurrentTabAction();
        if (currentTab != null) {
            return currentTab.getId();
        }
        return null;
    }

    public void setCurrentTabId(String tabId) {
        List<Action> tabsList;
        boolean set = false;
        if (tabId != null && !"".equals(tabId) && (tabsList = this.getTabsList()) != null) {
            for (Action a : tabsList) {
                if (!a.getId().equals(tabId)) continue;
                this.setCurrentTabAction(a);
                set = true;
                break;
            }
        }
        if (!set && (tabId == null || "".equals(tabId))) {
            this.setCurrentTabAction((Action)null);
        }
    }

    public String getCurrentSubTabId() {
        Action currentSubTab = this.getCurrentSubTabAction();
        if (currentSubTab != null) {
            return currentSubTab.getId();
        }
        return null;
    }

    public void setCurrentSubTabId(String tabId) {
        boolean set = false;
        List<Action> subTabsList = this.getSubTabsList();
        if (subTabsList != null) {
            for (Action a : subTabsList) {
                if (!a.getId().equals(tabId)) continue;
                this.currentSubTabAction = a;
                set = true;
                break;
            }
        }
        if (!set && (tabId == null || "".equals(tabId))) {
            this.currentSubTabAction = null;
        }
    }

    public String setCurrentTabAndNavigate(String currentTabActionId) {
        return this.setCurrentTabAndNavigate(this.navigationContext.getCurrentDocument(), currentTabActionId);
    }

    public String setCurrentTabAndNavigate(DocumentModel document, String currentTabActionId) {
        String viewId = null;
        try {
            viewId = this.navigationContext.navigateToDocument(document);
        }
        catch (ClientException e) {
            // empty catch block
        }
        this.getTabsList();
        this.setCurrentTabId(currentTabActionId);
        return viewId;
    }

    public void selectTabAction() {
    }

    @Deprecated
    public String getCurrentLifeCycleState() throws ClientException {
        CoreSession documentManager = (CoreSession)Component.getInstance((String)"documentManager");
        return documentManager.getCurrentLifeCycleState(this.navigationContext.getCurrentDocument().getRef());
    }
}

