/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.clipboard;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.ejb.Remove;
import javax.faces.application.FacesMessage;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.remoting.WebRemote;
import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.core.Events;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.international.LocaleSelector;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.actions.Action;
import org.nuxeo.ecm.platform.types.Type;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.cache.SeamCacheHelper;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.clipboard.ClipboardActions;
import org.nuxeo.ecm.webapp.clipboard.SummaryEntry;
import org.nuxeo.ecm.webapp.clipboard.SummaryImpl;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListDescriptor;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;
import org.nuxeo.ecm.webapp.helpers.EventManager;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="clipboardActions")
@Scope(value=ScopeType.SESSION)
public class ClipboardActionsBean
extends InputController
implements ClipboardActions,
Serializable {
    private static final long serialVersionUID = -2407222456116573225L;
    private static final Log log = LogFactory.getLog(ClipboardActionsBean.class);
    private static final int BUFFER = 2048;
    private static final String SUMMARY_FILENAME = "INDEX.txt";
    private static final String SUMMARY_HEADER = ".";
    private static final String PASTE_OUTCOME = "after_paste";
    @Deprecated
    public static final String DELETED_LIFECYCLE_STATE = "deleted";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    @In(create=true)
    protected transient WebActions webActions;
    @In(create=true)
    protected transient LocaleSelector localeSelector;
    @RequestParameter
    protected String workListDocId;
    private String currentSelectedList;
    private String previouslySelectedList;
    private transient List<String> availableLists;
    private transient List<DocumentsListDescriptor> descriptorsForAvailableLists;
    private Boolean canEditSelectedDocs;
    private transient Map<String, List<Action>> actionCache;
    @RequestParameter
    String listIdToSelect;

    @Override
    public void releaseClipboardableDocuments() {
    }

    @Override
    public boolean isInitialized() {
        return this.documentManager != null;
    }

    @Override
    public void putSelectionInWorkList(Boolean forceAppend) {
        this.canEditSelectedDocs = null;
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            this.putSelectionInWorkList(this.documentsListsManager.getWorkingList("CURRENT_SELECTION"), forceAppend);
            this.autoSelectCurrentList("DEFAULT");
        } else {
            log.debug((Object)"No selectable Documents in context to process copy on...");
        }
        log.debug((Object)"add to worklist processed...");
    }

    @Override
    public void putSelectionInWorkList() {
        this.putSelectionInWorkList(false);
    }

    @Override
    public void putSelectionInDefaultWorkList() {
        this.canEditSelectedDocs = null;
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            List<DocumentModel> docsList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            Object[] params = new Object[]{docsList.size()};
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_copied_docs"), params);
            this.documentsListsManager.addToWorkingList("DEFAULT", docsList);
            this.autoSelectCurrentList("DEFAULT");
        } else {
            log.debug((Object)"No selectable Documents in context to process copy on...");
        }
        log.debug((Object)"add to worklist processed...");
    }

    @Override
    @WebRemote
    public void putInClipboard(String docId) throws ClientException {
        DocumentModel doc = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        this.documentsListsManager.addToWorkingList("CLIPBOARD", doc);
        Object[] params = new Object[]{1};
        FacesMessage message = FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("#0 " + this.resourcesAccessor.getMessages().get("n_copied_docs")), (Object[])params);
        this.facesMessages.add(message);
        this.autoSelectCurrentList("CLIPBOARD");
    }

    @Override
    public void putSelectionInClipboard() {
        this.canEditSelectedDocs = null;
        if (!this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION")) {
            List<DocumentModel> docsList = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            Object[] params = new Object[]{docsList.size()};
            FacesMessage message = FacesMessages.createFacesMessage((FacesMessage.Severity)FacesMessage.SEVERITY_INFO, (String)("#0 " + this.resourcesAccessor.getMessages().get("n_copied_docs")), (Object[])params);
            this.facesMessages.add(message);
            this.documentsListsManager.addToWorkingList("CLIPBOARD", docsList);
            this.autoSelectCurrentList("CLIPBOARD");
        } else {
            log.debug((Object)"No selectable Documents in context to process copy on...");
        }
        log.debug((Object)"add to worklist processed...");
    }

    @Override
    public void putSelectionInWorkList(List<DocumentModel> docsList) {
        this.putSelectionInWorkList(docsList, false);
    }

    @Override
    public void putSelectionInWorkList(List<DocumentModel> docsList, Boolean forceAppend) {
        this.canEditSelectedDocs = null;
        if (null != docsList) {
            Object[] params = new Object[]{docsList.size()};
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_added_to_worklist_docs"), params);
            this.documentsListsManager.addToWorkingList(this.getCurrentSelectedListName(), docsList, forceAppend);
            log.debug((Object)"Elements copied to clipboard...");
        } else {
            log.debug((Object)"No copiedDocs to process copy on...");
        }
        log.debug((Object)"add to worklist processed...");
    }

    @Override
    @Deprecated
    public void copySelection(List<DocumentModel> copiedDocs) {
        if (null != copiedDocs) {
            Object[] params = new Object[]{copiedDocs.size()};
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_copied_docs"), params);
            this.documentsListsManager.resetWorkingList("CLIPBOARD");
            this.documentsListsManager.addToWorkingList("CLIPBOARD", copiedDocs);
            this.documentsListsManager.addToWorkingList(copiedDocs);
            log.debug((Object)"Elements copied to clipboard...");
        } else {
            log.debug((Object)"No copiedDocs to process copy on...");
        }
        log.debug((Object)"Copy processed...");
    }

    @Override
    public String removeWorkListItem(DocumentRef ref) throws ClientException {
        DocumentModel doc = this.documentManager.getDocument(ref);
        this.documentsListsManager.removeFromWorkingList(this.getCurrentSelectedListName(), doc);
        return null;
    }

    @Override
    public String clearWorkingList() {
        this.documentsListsManager.resetWorkingList(this.getCurrentSelectedListName());
        return null;
    }

    @Override
    public String pasteDocumentList(String listName) throws ClientException {
        return this.pasteDocumentList(this.documentsListsManager.getWorkingList(listName));
    }

    @Override
    public String pasteDocumentListInside(String listName, String docId) throws ClientException {
        return this.pasteDocumentListInside(this.documentsListsManager.getWorkingList(listName), docId);
    }

    @Override
    public String pasteDocumentList(List<DocumentModel> docPaste) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (null != docPaste) {
            List<DocumentModel> newDocs = this.recreateDocumentsWithNewParent(this.getParent(currentDocument), docPaste);
            Object[] params = new Object[]{newDocs.size()};
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_pasted_docs"), params);
            EventManager.raiseEventsOnDocumentSelected(currentDocument);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{currentDocument});
            log.debug((Object)"Elements pasted and created into the backend...");
        } else {
            log.debug((Object)"No docPaste to process paste on...");
        }
        return this.computeOutcome(PASTE_OUTCOME);
    }

    @Override
    public String pasteDocumentListInside(List<DocumentModel> docPaste, String docId) throws ClientException {
        DocumentModel targetDoc = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        if (null != docPaste) {
            List<DocumentModel> newDocs = this.recreateDocumentsWithNewParent(targetDoc, docPaste);
            Object[] params = new Object[]{newDocs.size()};
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_pasted_docs"), params);
            EventManager.raiseEventsOnDocumentSelected(targetDoc);
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{targetDoc});
            log.debug((Object)"Elements pasted and created into the backend...");
        } else {
            log.debug((Object)"No docPaste to process paste on...");
        }
        return null;
    }

    public List<DocumentModel> moveDocumentsToNewParent(DocumentModel destFolder, List<DocumentModel> docs) throws ClientException {
        Collection allowed = this.typeManager.getAllowedSubTypes(destFolder.getType());
        ArrayList<String> allowedList = new ArrayList<String>();
        for (Type allowedType : allowed) {
            allowedList.add(allowedType.getId());
        }
        DocumentRef destFolderRef = destFolder.getRef();
        ArrayList<DocumentModel> newDocs = new ArrayList<DocumentModel>();
        for (DocumentModel docModel : docs) {
            DocumentRef sourceFolderRef = docModel.getParentRef();
            String sourceType = docModel.getType();
            boolean canRemoveDoc = this.documentManager.hasPermission(sourceFolderRef, "RemoveChildren");
            boolean canPasteInCurrentFolder = allowedList.contains(sourceType);
            boolean sameFolder = sourceFolderRef.equals(destFolderRef);
            if (!canRemoveDoc || !canPasteInCurrentFolder || sameFolder) continue;
            DocumentModel newDoc = this.documentManager.move(docModel.getRef(), destFolderRef, null);
            newDocs.add(newDoc);
        }
        this.documentManager.save();
        return newDocs;
    }

    public String moveDocumentList(String listName, String docId) throws ClientException {
        List<DocumentModel> docs = this.documentsListsManager.getWorkingList(listName);
        DocumentModel targetDoc = this.documentManager.getDocument((DocumentRef)new IdRef(docId));
        HashSet<DocumentRef> parentRefs = new HashSet<DocumentRef>();
        for (DocumentModel doc : docs) {
            parentRefs.add(doc.getParentRef());
        }
        List<DocumentModel> newDocs = this.moveDocumentsToNewParent(targetDoc, docs);
        this.documentsListsManager.getWorkingList(listName).clear();
        Object[] params = new Object[]{newDocs.size()};
        this.facesMessages.add(FacesMessage.SEVERITY_INFO, "#0 " + this.resourcesAccessor.getMessages().get("n_moved_docs"), params);
        EventManager.raiseEventsOnDocumentSelected(targetDoc);
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{targetDoc});
        for (DocumentRef docRef : parentRefs) {
            Events.instance().raiseEvent("documentChildrenChanged", new Object[]{this.documentManager.getDocument(docRef)});
        }
        log.debug((Object)"Elements moved and created into the backend...");
        return null;
    }

    public String moveDocumentList(String listName) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.moveDocumentList(listName, currentDocument.getId());
    }

    @Override
    public String moveWorkingList() throws ClientException {
        this.moveDocumentList(this.getCurrentSelectedListName());
        return null;
    }

    @Override
    public String pasteWorkingList() throws ClientException {
        this.pasteDocumentList(this.getCurrentSelectedList());
        return null;
    }

    @Override
    public String pasteClipboard() throws ClientException {
        this.pasteDocumentList("CLIPBOARD");
        this.returnToPreviouslySelectedList();
        return null;
    }

    @Override
    @WebRemote
    public String pasteClipboardInside(String docId) throws ClientException {
        this.pasteDocumentListInside("CLIPBOARD", docId);
        return null;
    }

    @Override
    @WebRemote
    public String moveClipboardInside(String docId) throws ClientException {
        this.moveDocumentList("CLIPBOARD", docId);
        return null;
    }

    protected List<DocumentModel> recreateDocumentsWithNewParent(DocumentModel parent, List<DocumentModel> documents) throws ClientException {
        ArrayList<DocumentModel> newDocuments = new ArrayList<DocumentModel>();
        if (null == parent || null == documents) {
            log.error((Object)"Null params received, returning...");
            return newDocuments;
        }
        LinkedList<DocumentModel> documentsToPast = new LinkedList<DocumentModel>();
        Collection allowedTypes = this.typeManager.getAllowedSubTypes(parent.getType());
        LinkedList<String> allowedTypesNames = new LinkedList<String>();
        for (Type tip : allowedTypes) {
            allowedTypesNames.add(tip.getId());
        }
        for (DocumentModel doc : documents) {
            if (!allowedTypesNames.contains(doc.getType())) continue;
            documentsToPast.add(doc);
        }
        boolean isPublishSpace = this.isPublishSpace(parent);
        ArrayList<DocumentRef> docRefs = new ArrayList<DocumentRef>();
        ArrayList<DocumentRef> proxyRefs = new ArrayList<DocumentRef>();
        for (DocumentModel doc : documentsToPast) {
            if (doc.isProxy() && !isPublishSpace) {
                proxyRefs.add(doc.getRef());
                continue;
            }
            docRefs.add(doc.getRef());
        }
        if (!proxyRefs.isEmpty()) {
            newDocuments.addAll(this.documentManager.copyProxyAsDocument(proxyRefs, parent.getRef()));
        }
        if (!docRefs.isEmpty()) {
            newDocuments.addAll(this.documentManager.copy(docRefs, parent.getRef()));
        }
        this.documentManager.save();
        return newDocuments;
    }

    protected boolean isPublishSpace(DocumentModel container) throws ClientException {
        SchemaManager schemaManager;
        try {
            schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        HashSet<String> publishSpaces = null;
        if (schemaManager != null) {
            publishSpaces = schemaManager.getDocumentTypeNamesForFacet("PublishSpace");
        }
        if (publishSpaces == null || publishSpaces.isEmpty()) {
            publishSpaces = new HashSet<String>();
            publishSpaces.add("Section");
        }
        return publishSpaces.contains(container.getType());
    }

    @Override
    @Destroy
    @Remove
    public void destroy() {
        log.debug((Object)"Removing Seam component: clipboardActions");
    }

    protected DocumentModel getParent(DocumentModel currentDocument) throws ClientException {
        if (currentDocument.isFolder()) {
            return currentDocument;
        }
        DocumentModelList parents = this.navigationContext.getCurrentPath();
        for (int i = parents.size() - 1; i >= 0; --i) {
            DocumentModel parent = (DocumentModel)parents.get(i);
            if (!parent.isFolder()) continue;
            return parent;
        }
        return null;
    }

    @Override
    @Factory(value="isCurrentWorkListEmpty", scope=ScopeType.EVENT)
    public boolean factoryForIsCurrentWorkListEmpty() {
        return this.isWorkListEmpty();
    }

    @Override
    public boolean isWorkListEmpty() {
        return this.documentsListsManager.isWorkingListEmpty(this.getCurrentSelectedListName());
    }

    @Override
    public String exportWorklistAsZip() throws ClientException {
        return this.exportWorklistAsZip(this.documentsListsManager.getWorkingList(this.getCurrentSelectedListName()));
    }

    @Override
    public String exportAllBlobsFromWorkingListAsZip() throws ClientException {
        return this.exportWorklistAsZip();
    }

    @Override
    public String exportMainBlobFromWorkingListAsZip() throws ClientException {
        return this.exportWorklistAsZip();
    }

    @Override
    public String exportWorklistAsZip(List<DocumentModel> documents) throws ClientException {
        return this.exportWorklistAsZip(documents, true);
    }

    @Override
    public String exportWorklistAsZip(List<DocumentModel> documents, boolean exportAllBlobs) throws ClientException {
        try {
            SummaryImpl summary = new SummaryImpl();
            SummaryEntry summaryRoot = new SummaryEntry("", SUMMARY_HEADER, new Date(), "", "", null);
            summaryRoot.setDocumentRef((DocumentRef)new IdRef("0"));
            summary.put(new IdRef("0").toString(), summaryRoot);
            FacesContext context = FacesContext.getCurrentInstance();
            HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
            BufferedOutputStream buff = new BufferedOutputStream((OutputStream)response.getOutputStream());
            ZipOutputStream out = new ZipOutputStream(buff);
            out.setMethod(8);
            out.setLevel(9);
            byte[] data = new byte[2048];
            for (DocumentModel doc : documents) {
                if (doc.getSessionId() == null) {
                    doc = this.documentManager.getDocument(doc.getRef());
                }
                if (DELETED_LIFECYCLE_STATE.equals(doc.getCurrentLifeCycleState())) continue;
                BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
                if (doc.isFolder() && !this.isEmptyFolder(doc, this.documentManager)) {
                    SummaryEntry summaryLeaf = new SummaryEntry(doc);
                    summaryLeaf.setParent(summaryRoot);
                    if (doc.getType().equals("Workspace") || doc.getType().equals("WorkspaceRoot")) {
                        summaryLeaf.setFilename("");
                    }
                    summary.put(summaryLeaf.getPath(), summaryLeaf);
                    this.addFolderToZip("", out, doc, data, this.documentManager, (SummaryEntry)summary.get(summaryLeaf.getPath()), summary, exportAllBlobs);
                    continue;
                }
                if (bh == null) continue;
                this.addBlobHolderToZip("", out, doc, data, summary.getSummaryRoot(), summary, bh, exportAllBlobs);
            }
            if (summary.size() > 1) {
                this.addSummaryToZip(out, data, summary);
            }
            try {
                out.close();
            }
            catch (ZipException e) {
                this.setFacesMessage("label.clipboard.emptyDocuments");
                return null;
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"clipboard.zip\";");
            response.setContentType("application/gzip");
            response.flushBuffer();
            context.responseComplete();
            return null;
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    @Override
    public boolean getCanCopy() {
        if (this.navigationContext.getCurrentDocument() == null) {
            return false;
        }
        return !this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION");
    }

    @Override
    public boolean getCanPaste(String listName) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (this.documentsListsManager.isWorkingListEmpty(listName) || currentDocument == null) {
            return false;
        }
        DocumentModel pasteTarget = this.getParent(this.navigationContext.getCurrentDocument());
        if (!this.documentManager.hasPermission(pasteTarget.getRef(), "AddChildren")) {
            return false;
        }
        List<String> pasteTypesName = this.documentsListsManager.getWorkingListTypes(listName);
        Collection allowed = this.typeManager.getAllowedSubTypes(pasteTarget.getType());
        for (Type allowedType : allowed) {
            if (!pasteTypesName.contains(allowedType.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getCanPasteInside(String listName, DocumentModel document) throws ClientException {
        if (this.documentsListsManager.isWorkingListEmpty(listName) || document == null) {
            return false;
        }
        if (!this.documentManager.hasPermission(document.getRef(), "AddChildren")) {
            return false;
        }
        List<String> pasteTypesName = this.documentsListsManager.getWorkingListTypes(listName);
        Collection allowed = this.typeManager.getAllowedSubTypes(document.getType());
        for (Type allowedType : allowed) {
            if (!pasteTypesName.contains(allowedType.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean getCanMoveInside(String listName, DocumentModel document) throws ClientException {
        if (this.documentsListsManager.isWorkingListEmpty(listName) || document == null) {
            return false;
        }
        DocumentRef destFolderRef = document.getRef();
        DocumentModel destFolder = document;
        if (!this.documentManager.hasPermission(destFolderRef, "AddChildren")) {
            return false;
        }
        Collection allowed = this.typeManager.getAllowedSubTypes(destFolder.getType());
        ArrayList<String> allowedList = new ArrayList<String>();
        for (Type allowedType : allowed) {
            allowedList.add(allowedType.getId());
        }
        for (DocumentModel docModel : this.documentsListsManager.getWorkingList(listName)) {
            DocumentRef sourceFolderRef = docModel.getParentRef();
            String sourceType = docModel.getType();
            boolean canRemoveDoc = this.documentManager.hasPermission(sourceFolderRef, "RemoveChildren");
            boolean canPasteInCurrentFolder = allowedList.contains(sourceType);
            boolean sameFolder = sourceFolderRef.equals(destFolderRef);
            if (!canRemoveDoc || !canPasteInCurrentFolder || sameFolder) continue;
            return true;
        }
        return false;
    }

    public boolean getCanMove(String listName) throws ClientException {
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        return this.getCanMoveInside(listName, currentDocument);
    }

    @Override
    public boolean getCanPasteWorkList() throws ClientException {
        return this.getCanPaste(this.getCurrentSelectedListName());
    }

    @Override
    public boolean getCanMoveWorkingList() throws ClientException {
        return this.getCanMove(this.getCurrentSelectedListName());
    }

    @Override
    public boolean getCanPasteFromClipboard() throws ClientException {
        return this.getCanPaste("CLIPBOARD");
    }

    @Override
    public boolean getCanPasteFromClipboardInside(DocumentModel document) throws ClientException {
        return this.getCanPasteInside("CLIPBOARD", document);
    }

    @Override
    public boolean getCanMoveFromClipboardInside(DocumentModel document) throws ClientException {
        return this.getCanMoveInside("CLIPBOARD", document);
    }

    private void addFolderToZip(String path, ZipOutputStream out, DocumentModel doc, byte[] data, CoreSession documentManager, SummaryEntry parent, SummaryImpl summary, boolean exportAllBlobs) throws ClientException, IOException {
        String title = (String)doc.getProperty("dublincore", "title");
        DocumentModelList docList = documentManager.getChildren(doc.getRef());
        for (DocumentModel docChild : docList) {
            if (DELETED_LIFECYCLE_STATE.equals(docChild.getCurrentLifeCycleState())) continue;
            BlobHolder bh = (BlobHolder)docChild.getAdapter(BlobHolder.class);
            if (docChild.isFolder() && !this.isEmptyFolder(docChild, documentManager)) {
                SummaryEntry summaryLeaf = new SummaryEntry(docChild);
                if (doc.getType().equals("Workspace") || doc.getType().equals("WorkspaceRoot")) {
                    summaryLeaf.setFilename("");
                }
                summaryLeaf.setParent(parent);
                summary.put(summaryLeaf.getPath(), summaryLeaf);
                this.addFolderToZip(path + title + "/", out, docChild, data, documentManager, (SummaryEntry)summary.get(summaryLeaf.getPath()), summary, exportAllBlobs);
                continue;
            }
            if (bh == null) continue;
            this.addBlobHolderToZip(path + title + "/", out, docChild, data, (SummaryEntry)summary.get(parent.getPath()), summary, bh, exportAllBlobs);
        }
    }

    private boolean isEmptyFolder(DocumentModel doc, CoreSession documentManager) throws ClientException {
        DocumentModelList docList = documentManager.getChildren(doc.getRef());
        for (DocumentModel docChild : docList) {
            if (docChild.getAdapter(BlobHolder.class) == null && !docChild.isFolder()) continue;
            return false;
        }
        return true;
    }

    private void addSummaryToZip(ZipOutputStream out, byte[] data, SummaryImpl summary) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(summary.toString());
        StringBlob content = new StringBlob(sb.toString());
        BufferedInputStream buffi = new BufferedInputStream(content.getStream(), 2048);
        ZipEntry entry = new ZipEntry(SUMMARY_FILENAME);
        out.putNextEntry(entry);
        int count = buffi.read(data, 0, 2048);
        while (count != -1) {
            out.write(data, 0, count);
            count = buffi.read(data, 0, 2048);
        }
        out.closeEntry();
        buffi.close();
    }

    private void addBlobHolderToZip(String path, ZipOutputStream out, DocumentModel doc, byte[] data, SummaryEntry parent, SummaryImpl summary, BlobHolder bh, boolean exportAllBlobs) throws IOException, ClientException {
        List<Blob> blobs = new ArrayList();
        if (exportAllBlobs) {
            blobs = bh.getBlobs();
        } else {
            Blob mainBlob = bh.getBlob();
            if (mainBlob != null) {
                blobs.add(mainBlob);
            }
        }
        for (Blob content : blobs) {
            String fileName = content.getFilename();
            if (content == null) continue;
            SummaryEntry summaryLeaf = new SummaryEntry(doc);
            summaryLeaf.setParent(parent);
            summary.put(summaryLeaf.getPath(), summaryLeaf);
            BufferedInputStream buffi = new BufferedInputStream(content.getStream(), 2048);
            int tryCount = 0;
            while (true) {
                try {
                    ZipEntry entry = tryCount == 0 ? new ZipEntry(path + fileName) : new ZipEntry(path + this.formatFileName(fileName, "(" + tryCount + ")"));
                    out.putNextEntry(entry);
                }
                catch (ZipException e) {
                    ++tryCount;
                    continue;
                }
                break;
            }
            int count = buffi.read(data, 0, 2048);
            while (count != -1) {
                out.write(data, 0, count);
                count = buffi.read(data, 0, 2048);
            }
            out.closeEntry();
            buffi.close();
        }
    }

    private String formatFileName(String filename, String count) {
        StringBuilder sb = new StringBuilder();
        CharSequence name = filename.subSequence(0, filename.lastIndexOf(SUMMARY_HEADER));
        CharSequence extension = filename.subSequence(filename.lastIndexOf(SUMMARY_HEADER), filename.length());
        sb.append(name).append(count).append(extension);
        return sb.toString();
    }

    @Override
    public void setCurrentSelectedList(String listId) {
        if (listId != null && !listId.equals(this.currentSelectedList)) {
            this.currentSelectedList = listId;
            this.canEditSelectedDocs = null;
        }
    }

    @Override
    public void selectList() {
        if (this.listIdToSelect != null) {
            this.setCurrentSelectedList(this.listIdToSelect);
        }
    }

    @Override
    public List<DocumentModel> getCurrentSelectedList() {
        return this.documentsListsManager.getWorkingList(this.getCurrentSelectedListName());
    }

    @Override
    public String getCurrentSelectedListName() {
        if (this.currentSelectedList == null && !this.getAvailableLists().isEmpty()) {
            this.setCurrentSelectedList(this.availableLists.get(0));
        }
        return this.currentSelectedList;
    }

    @Override
    public String getCurrentSelectedListTitle() {
        DocumentsListDescriptor desc;
        String title = null;
        String listName = this.getCurrentSelectedListName();
        if (listName != null && (desc = this.documentsListsManager.getWorkingListDescriptor(listName)) != null) {
            title = desc.getTitle();
        }
        return title;
    }

    @Override
    public List<String> getAvailableLists() {
        if (this.availableLists == null) {
            this.availableLists = this.documentsListsManager.getWorkingListNamesForCategory("CLIPBOARD");
        }
        return this.availableLists;
    }

    @Override
    public List<DocumentsListDescriptor> getDescriptorsForAvailableLists() {
        if (this.descriptorsForAvailableLists == null) {
            List<String> availableLists = this.getAvailableLists();
            this.descriptorsForAvailableLists = new ArrayList<DocumentsListDescriptor>();
            for (String lName : availableLists) {
                this.descriptorsForAvailableLists.add(this.documentsListsManager.getWorkingListDescriptor(lName));
            }
        }
        return this.descriptorsForAvailableLists;
    }

    @Override
    public List<Action> getActionsForCurrentList() {
        String lstName = this.getCurrentSelectedListName();
        if (this.isWorkListEmpty()) {
            if (this.actionCache == null) {
                this.actionCache = new HashMap<String, List<Action>>();
            }
            if (!this.actionCache.containsKey(lstName)) {
                this.actionCache.put(lstName, this.webActions.getActionsList(lstName + "_LIST"));
            }
            return this.actionCache.get(lstName);
        }
        return this.webActions.getActionsList(lstName + "_LIST");
    }

    @Override
    public List<Action> getActionsForSelection() {
        return this.webActions.getUnfiltredActionsList("CURRENT_SELECTION_LIST");
    }

    private void autoSelectCurrentList(String listName) {
        this.previouslySelectedList = this.getCurrentSelectedListName();
        this.setCurrentSelectedList(listName);
    }

    private void returnToPreviouslySelectedList() {
        this.setCurrentSelectedList(this.previouslySelectedList);
    }

    @Override
    public boolean getCanEditSelectedDocs() throws ClientException {
        if (this.canEditSelectedDocs == null) {
            if (this.getCurrentSelectedList().isEmpty()) {
                this.canEditSelectedDocs = false;
            } else {
                List<DocumentModel> selectedDocs = this.getCurrentSelectedList();
                this.canEditSelectedDocs = this.checkWritePerm(selectedDocs);
            }
        }
        return this.canEditSelectedDocs;
    }

    @Override
    @Deprecated
    public boolean getCanEditListDocs(String listName) throws ClientException {
        List<DocumentModel> docs = this.documentsListsManager.getWorkingList(listName);
        boolean canEdit = docs.isEmpty() ? false : this.checkWritePerm(docs);
        return canEdit;
    }

    private boolean checkWritePerm(List<DocumentModel> selectedDocs) throws ClientException {
        for (DocumentModel documentModel : selectedDocs) {
            boolean canWrite = this.documentManager.hasPermission(documentModel.getRef(), "WriteProperties");
            if (canWrite) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isCacheEnabled() {
        if (!SeamCacheHelper.canUseSeamCache()) {
            return false;
        }
        return this.isWorkListEmpty();
    }

    @Override
    public String getCacheKey() {
        return this.getCurrentSelectedListName() + "::" + this.localeSelector.getLocaleString();
    }

    @Override
    public boolean isCacheEnabledForSelection() {
        if (!SeamCacheHelper.canUseSeamCache()) {
            return false;
        }
        return this.documentsListsManager.isWorkingListEmpty("CURRENT_SELECTION");
    }
}

