/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.contentbrowser;

import java.io.Serializable;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PagedDocumentsProvider;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.platform.ui.web.api.ResultsProviderFarm;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.pagination.ResultsProvidersCache;
import org.nuxeo.ecm.webapp.querymodel.QueryModelActions;

@Name(value="documentChildrenSearchFarm")
@Scope(value=ScopeType.SESSION)
public class DocumentChildrenSearchFarm
extends InputController
implements ResultsProviderFarm,
Serializable {
    private static final long serialVersionUID = 8331654530334881666L;
    private static final String FILTER_SCHEMA_NAME = "browsing_filters";
    private static final String FILTER_FIELD_NAME_PARENT_ID = "query_parentId";
    @In(create=true)
    private transient QueryModelActions queryModelActions;
    @In(create=true)
    private transient ResultsProvidersCache resultsProvidersCache;
    @In(create=true, required=false)
    private transient CoreSession documentManager;

    public PagedDocumentsProvider getResultsProvider(String name) throws ClientException {
        return this.getResultsProvider(name, null);
    }

    public PagedDocumentsProvider getResultsProvider(String name, SortInfo sortInfo) throws ClientException {
        DocumentModel currentDoc = this.navigationContext.getCurrentDocument();
        if ("CURRENT_DOC_CHILDREN".equals(name)) {
            PagedDocumentsProvider provider = this.getChildrenResultsProviderQMPattern(name, currentDoc, sortInfo);
            provider.setName(name);
            return provider;
        }
        throw new ClientException("Unknown provider: " + name);
    }

    private PagedDocumentsProvider getChildrenResultsProviderQMPattern(String queryModelName, DocumentModel parent, SortInfo sortInfo) throws ClientException {
        String parentId = parent.getId();
        Object[] params = new Object[]{parentId};
        return this.getResultsProvider(queryModelName, params, sortInfo);
    }

    private PagedDocumentsProvider getResultsProvider(String qmName, Object[] params, SortInfo sortInfo) throws ClientException {
        QueryModel qm = this.queryModelActions.get(qmName);
        return qm.getResultsProvider(this.documentManager, params, sortInfo);
    }

    protected PagedDocumentsProvider getChildrenResultsProviderQMPred(String queryModelName, DocumentModel currentDoc) throws ClientException {
        QueryModel qm = this.queryModelActions.get(queryModelName);
        if (qm == null) {
            throw new ClientException("no QueryModel registered under name: " + queryModelName);
        }
        String currentRef = currentDoc.getRef().toString();
        if (!currentRef.equals(qm.getProperty(FILTER_SCHEMA_NAME, FILTER_FIELD_NAME_PARENT_ID))) {
            qm.setProperty(FILTER_SCHEMA_NAME, FILTER_FIELD_NAME_PARENT_ID, (Object)currentRef);
            this.resultsProvidersCache.invalidate(queryModelName);
        }
        return this.resultsProvidersCache.get(queryModelName);
    }
}

