/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.helpers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.Startup;
import org.jboss.seam.core.Events;
import org.nuxeo.ecm.core.api.DocumentModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="eventManager")
@Scope(value=ScopeType.APPLICATION)
@Startup
@Install(precedence=10)
public class EventManager
implements Serializable {
    private static final long serialVersionUID = -7572053704069819975L;
    private static final Log log = LogFactory.getLog(EventManager.class);

    public static List<String> raiseEventsOnGoingHome() {
        ArrayList<String> eventsFired = new ArrayList<String>();
        Events evtManager = Events.instance();
        log.debug((Object)"Fire Event: locationSelectionChanged");
        evtManager.raiseEvent("locationSelectionChanged", new Object[0]);
        eventsFired.add("locationSelectionChanged");
        log.debug((Object)"Fire Event: goHome");
        evtManager.raiseEvent("goHome", new Object[0]);
        eventsFired.add("goHome");
        return eventsFired;
    }

    public static List<String> raiseEventsOnLocationSelectionChanged() {
        ArrayList<String> eventsFired = new ArrayList<String>();
        Events evtManager = Events.instance();
        log.debug((Object)"Fire Event: locationSelectionChanged");
        evtManager.raiseEvent("locationSelectionChanged", new Object[0]);
        eventsFired.add("locationSelectionChanged");
        log.debug((Object)"Fire Event: userAllDocumentTypesSelectionChanged");
        evtManager.raiseEvent("userAllDocumentTypesSelectionChanged", new Object[0]);
        eventsFired.add("userAllDocumentTypesSelectionChanged");
        return eventsFired;
    }

    public static List<String> raiseEventsOnDocumentSelected(DocumentModel document) {
        ArrayList<String> eventsFired = new ArrayList();
        if (document == null) {
            eventsFired = EventManager.raiseEventsOnLocationSelectionChanged();
        } else {
            Events evtManager = Events.instance();
            String docType = document.getType();
            String eventName = "Domain".equals(docType) ? "domainSelectionChanged" : ("Root".equals(docType) ? "goHome" : ("WorkspaceRoot".equals(docType) || "SectionRoot".equals(docType) ? "contentRootSelectionChanged" : "documentSelectionChanged"));
            if (document.isFolder()) {
                evtManager.raiseEvent("folderishDocumentSelectionChanged", new Object[]{document});
            }
            log.debug((Object)("Fire Event: " + eventName));
            evtManager.raiseEvent(eventName, new Object[]{document});
            eventsFired.add(eventName);
            log.debug((Object)"Fire Event: userAllDocumentTypesSelectionChanged");
            evtManager.raiseEvent("userAllDocumentTypesSelectionChanged", new Object[0]);
            eventsFired.add("userAllDocumentTypesSelectionChanged");
        }
        return eventsFired;
    }

    public static List<String> raiseEventsOnDocumentChange(DocumentModel document) {
        ArrayList<String> eventsFired = new ArrayList<String>();
        Events evtManager = Events.instance();
        log.debug((Object)"Fire Event: documentChanged");
        evtManager.raiseEvent("documentChanged", new Object[]{document});
        eventsFired.add("documentChanged");
        log.debug((Object)"Fire Event: userAllDocumentTypesSelectionChanged");
        evtManager.raiseEvent("userAllDocumentTypesSelectionChanged", new Object[0]);
        eventsFired.add("userAllDocumentTypesSelectionChanged");
        return eventsFired;
    }

    public static void raiseEventsOnDocumentCreate(DocumentModel document) {
        Events.instance().raiseEvent("changeableDocumentCreated", new Object[0]);
    }

    public static List<String> raiseEventsOnDocumentChildrenChange(DocumentModel document) {
        ArrayList<String> eventsFired = new ArrayList<String>();
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{document});
        eventsFired.add("documentChildrenChanged");
        return eventsFired;
    }
}

