/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.seam;

import java.io.File;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.Seam;
import org.jboss.seam.core.Init;
import org.jboss.seam.exception.Exceptions;
import org.jboss.seam.init.Initialization;
import org.jboss.seam.navigation.Pages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamHotReloadHelper {
    private static final Log log = LogFactory.getLog(SeamHotReloadHelper.class);
    public static final String SEAM_HOT_RELOAD_SYSTEM_PROP = "org.nuxeo.seam.debug";

    public static boolean isHotReloadEnabled() {
        String sysProp = System.getProperty(SEAM_HOT_RELOAD_SYSTEM_PROP, "false");
        return "true".equalsIgnoreCase(sysProp);
    }

    public static Set<String> reloadSeamComponents(HttpServletRequest httpRequest) {
        ServletContext servletContext = httpRequest.getSession().getServletContext();
        boolean reloadDone = false;
        Init init = (Init)servletContext.getAttribute(Seam.getComponentName(Init.class));
        if (init != null && init.hasHotDeployableComponents()) {
            for (File file : init.getHotDeployPaths()) {
                if (!SeamHotReloadHelper.scan(init, file)) continue;
                Seam.clearComponentNameCache();
                new Initialization(servletContext).redeploy(httpRequest);
                reloadDone = true;
                break;
            }
        }
        servletContext.removeAttribute(Seam.getComponentName(Pages.class));
        servletContext.removeAttribute(Seam.getComponentName(Exceptions.class));
        if (reloadDone) {
            return init.getHotDeployableComponents();
        }
        return null;
    }

    public static Set<String> getHotDeployableComponents(HttpServletRequest httpRequest) {
        ServletContext servletContext = httpRequest.getSession().getServletContext();
        Init init = (Init)servletContext.getAttribute(Seam.getComponentName(Init.class));
        return init.getHotDeployableComponents();
    }

    protected static boolean scan(Init init, File file) {
        if (file.isFile()) {
            if (!file.exists() || file.lastModified() > init.getTimestamp()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("file updated: " + file.getName()));
                }
                return true;
            }
        } else if (file.isDirectory()) {
            for (File f : file.listFiles()) {
                if (!SeamHotReloadHelper.scan(init, f)) continue;
                return true;
            }
        }
        return false;
    }
}

