/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.security;

import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import javax.faces.application.FacesMessage;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;
import org.jboss.seam.faces.FacesMessages;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.impl.DocumentModelListImpl;
import org.nuxeo.ecm.directory.SizeLimitExceededException;
import org.nuxeo.ecm.platform.ui.web.util.ComponentUtils;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.exceptions.GroupAlreadyExistsException;
import org.nuxeo.ecm.webapp.helpers.ResourcesAccessor;
import org.nuxeo.ecm.webapp.security.GroupManagerActions;

@Name(value="groupManagerActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=10)
public class GroupManagerActionsBean
implements GroupManagerActions {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GroupManagerActionsBean.class);
    @In(create=true)
    protected transient UserManager userManager;
    @In(create=true)
    protected Principal currentUser;
    @In(create=true, required=false)
    protected transient FacesMessages facesMessages;
    @In(create=true)
    protected transient ResourcesAccessor resourcesAccessor;
    @DataModel(value="groupList")
    protected DocumentModelList groups;
    @DataModelSelection(value="groupList")
    protected DocumentModel selectedGroup;
    protected DocumentModel newGroup;
    protected String groupListingMode;
    protected Boolean canEditGroups;
    protected String searchString = "";
    protected boolean searchOverflow;

    protected String getGroupListingMode() throws ClientException {
        if (this.groupListingMode == null) {
            this.groupListingMode = this.userManager.getGroupListingMode();
        }
        return this.groupListingMode;
    }

    @Factory(value="groupList")
    public DocumentModelList getGroups() throws ClientException {
        if (this.groups == null) {
            this.searchOverflow = false;
            try {
                String groupListingMode = this.getGroupListingMode();
                if ("all".equals(groupListingMode) || "*".equals(this.getTrimmedSearchString())) {
                    this.groups = this.userManager.searchGroups(Collections.emptyMap(), null);
                } else if (!StringUtils.isEmpty((String)this.getTrimmedSearchString())) {
                    HashMap<String, String> filter = new HashMap<String, String>();
                    filter.put(this.userManager.getGroupIdField(), this.getTrimmedSearchString());
                    this.groups = this.userManager.searchGroups(filter, new HashSet(filter.keySet()));
                }
            }
            catch (SizeLimitExceededException e) {
                this.searchOverflow = true;
            }
        }
        if (this.groups == null) {
            this.groups = new DocumentModelListImpl();
        }
        return this.groups;
    }

    public void resetGroups() {
        this.groups = null;
    }

    protected DocumentModel refreshGroup(String groupName) throws ClientException {
        return this.userManager.getGroupModel(groupName);
    }

    protected String viewGroup(DocumentModel group, boolean refresh) throws ClientException {
        if (group != null) {
            this.selectedGroup = group;
            if (refresh) {
                this.selectedGroup = this.refreshGroup(group.getId());
            }
            if (this.selectedGroup != null) {
                return "view_group";
            }
        }
        return null;
    }

    public String viewGroups() {
        return "view_groups";
    }

    public String viewGroup() throws ClientException {
        return this.viewGroup(this.selectedGroup, true);
    }

    public String viewGroup(String groupName) throws ClientException {
        return this.viewGroup(this.userManager.getGroupModel(groupName), false);
    }

    public String editGroup() throws ClientException {
        this.selectedGroup = this.refreshGroup(this.selectedGroup.getId());
        return "edit_group";
    }

    public DocumentModel getSelectedGroup() {
        return this.selectedGroup;
    }

    public DocumentModel getNewGroup() throws ClientException {
        if (this.newGroup == null) {
            this.newGroup = this.userManager.getBareGroupModel();
        }
        return this.newGroup;
    }

    public String deleteGroup() throws ClientException {
        try {
            this.userManager.deleteGroup(this.selectedGroup);
            this.resetGroups();
            return this.viewGroups();
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public String updateGroup() throws ClientException {
        try {
            this.userManager.updateGroup(this.selectedGroup);
            this.resetGroups();
            return this.viewGroup(this.selectedGroup.getId());
        }
        catch (Throwable t) {
            throw ClientException.wrap((Throwable)t);
        }
    }

    public void validateGroupName(FacesContext context, UIComponent component, Object value) {
        if (!(value instanceof String) || !StringUtils.containsOnly((String)((String)value), (String)"0123456789_-ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz")) {
            FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_ERROR, ComponentUtils.translate((FacesContext)context, (String)"label.groupManager.wrongGroupName"), null);
            ((EditableValueHolder)component).setValid(false);
            context.addMessage(component.getClientId(context), message);
            context.addMessage(null, message);
        }
    }

    public String createGroup() throws ClientException {
        try {
            this.selectedGroup = this.userManager.createGroup(this.newGroup);
            this.newGroup = null;
            this.resetGroups();
            this.facesMessages.add(FacesMessage.SEVERITY_INFO, this.resourcesAccessor.getMessages().get("info.groupManager.groupCreated"), new Object[0]);
            return this.viewGroup(this.selectedGroup, false);
        }
        catch (GroupAlreadyExistsException e) {
            String message = this.resourcesAccessor.getMessages().get("error.groupManager.groupAlreadyExists");
            this.facesMessages.addToControl("groupName", FacesMessage.SEVERITY_ERROR, message, new Object[0]);
            return null;
        }
    }

    protected boolean getCanEditGroups() throws ClientException {
        if (this.canEditGroups == null) {
            NuxeoPrincipal pal;
            this.canEditGroups = false;
            if (!this.userManager.areGroupsReadOnly().booleanValue() && this.currentUser instanceof NuxeoPrincipal && (pal = (NuxeoPrincipal)this.currentUser).isAdministrator()) {
                this.canEditGroups = true;
            }
        }
        return this.canEditGroups;
    }

    public boolean getAllowCreateGroup() throws ClientException {
        return this.getCanEditGroups();
    }

    public boolean getAllowDeleteGroup() throws ClientException {
        return this.getCanEditGroups();
    }

    public boolean getAllowEditGroup() throws ClientException {
        return this.getCanEditGroups();
    }

    public String getSearchString() {
        return this.searchString;
    }

    protected String getTrimmedSearchString() {
        if (this.searchString == null) {
            return null;
        }
        return this.searchString.trim();
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public String searchGroups() {
        this.resetGroups();
        return this.viewGroups();
    }

    public String clearSearch() {
        this.searchString = null;
        return this.searchGroups();
    }

    public boolean isSearchOverflow() {
        return this.searchOverflow;
    }
}

