/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.theme.negotiation;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.faces.model.SelectItem;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.webapp.theme.negotiation.LocalThemeActions;
import org.nuxeo.ecm.webapp.theme.negotiation.LocalThemeConfig;
import org.nuxeo.ecm.webapp.theme.negotiation.LocalThemeHelper;
import org.nuxeo.theme.Manager;
import org.nuxeo.theme.perspectives.PerspectiveManager;
import org.nuxeo.theme.perspectives.PerspectiveType;
import org.nuxeo.theme.themes.ThemeManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="localThemeActions")
@Scope(value=ScopeType.PAGE)
public class LocalThemeActionsBean
implements LocalThemeActions,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(LocalThemeActionsBean.class);
    @In(required=false, create=true)
    protected DocumentModel currentSuperSpace;
    protected String theme;
    protected String page;
    private String perspective;
    private String engine;
    private String mode;

    @Override
    @Create
    public void init() {
        LocalThemeConfig config;
        if (this.currentSuperSpace != null && (config = LocalThemeHelper.getLocalThemeConfig(this.currentSuperSpace)) != null) {
            this.theme = config.getTheme();
            this.page = config.getPage();
            this.perspective = config.getPerspective();
            this.engine = config.getEngine();
            this.mode = config.getMode();
        }
    }

    @Override
    public String getTheme() {
        return this.theme;
    }

    @Override
    public String getPage() {
        return this.page;
    }

    @Override
    public void setTheme(String theme) {
        this.theme = theme;
    }

    @Override
    public void setPage(String page) {
        this.page = page;
    }

    @Override
    public List<SelectItem> getAvailableThemes() {
        ArrayList<SelectItem> themes = new ArrayList<SelectItem>();
        Manager.getThemeManager();
        for (String theme : ThemeManager.getThemeNames((String)"jsf-facelets")) {
            themes.add(new SelectItem((Object)theme, theme));
        }
        return themes;
    }

    @Override
    public List<SelectItem> getAvailablePages() {
        ArrayList<SelectItem> pages = new ArrayList<SelectItem>();
        if (this.theme != null && !this.theme.equals("")) {
            for (String pageName : Manager.getThemeManager().getPageNames(this.theme)) {
                pages.add(new SelectItem((Object)pageName, pageName));
            }
        }
        return pages;
    }

    @Override
    public List<SelectItem> getAvailablePerspectives() {
        ArrayList<SelectItem> selectItemList = new ArrayList<SelectItem>();
        Manager.getPerspectiveManager();
        for (PerspectiveType perspectiveType : PerspectiveManager.listPerspectives()) {
            selectItemList.add(new SelectItem((Object)perspectiveType.name, perspectiveType.title));
        }
        return selectItemList;
    }

    @Override
    public List<SelectItem> getAvailableEngines() {
        ArrayList<SelectItem> engines = new ArrayList<SelectItem>();
        return engines;
    }

    @Override
    public void save() {
        if (this.currentSuperSpace == null) {
            log.error((Object)"Could not find the current space.");
            return;
        }
        LocalThemeHelper.setLocalThemeConfig(this.theme, this.page, this.perspective, this.engine, this.mode, this.currentSuperSpace);
    }

    @Override
    public void delete() {
        if (this.currentSuperSpace == null) {
            log.error((Object)"Could not find the current space.");
            return;
        }
        LocalThemeHelper.removeLocalThemeConfig(this.currentSuperSpace);
        this.theme = null;
        this.page = null;
        this.perspective = null;
        this.engine = null;
        this.mode = null;
    }

    @Override
    public boolean isConfigured() {
        LocalThemeConfig config;
        return this.currentSuperSpace != null && (config = LocalThemeHelper.getLocalThemeConfig(this.currentSuperSpace)) != null;
    }

    @Override
    public String getEngine() {
        return this.engine;
    }

    @Override
    public void setEngine(String engine) {
        this.engine = engine;
    }

    @Override
    public String getMode() {
        return this.mode;
    }

    @Override
    public void setMode(String mode) {
        this.mode = mode;
    }

    @Override
    public String getPerspective() {
        return this.perspective;
    }

    @Override
    public void setPerspective(String perspective) {
        this.perspective = perspective;
    }
}

