/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webapp.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.ejb.Remove;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.Filter;
import org.nuxeo.ecm.core.api.Sorter;
import org.nuxeo.ecm.core.search.api.client.querymodel.QueryModel;
import org.nuxeo.ecm.core.search.api.client.querymodel.descriptor.QueryModelDescriptor;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNode;
import org.nuxeo.ecm.webapp.tree.DocumentTreeNodeImpl;
import org.nuxeo.ecm.webapp.tree.TreeActions;
import org.nuxeo.ecm.webapp.tree.TreeManager;
import org.nuxeo.runtime.api.Framework;
import org.richfaces.component.UITree;
import org.richfaces.event.NodeExpandedEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Scope(value=ScopeType.CONVERSATION)
@Name(value="treeActions")
@Install(precedence=10)
public class TreeActionsBean
implements TreeActions,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(TreeActionsBean.class);
    public static final String NODE_SELECTED_MARKER = TreeActionsBean.class.getName() + "_NODE_SELECTED_MARKER";
    @In(create=true, required=false)
    protected transient CoreSession documentManager;
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected List<DocumentTreeNode> tree;
    protected String currentDocumentPath;

    @Override
    public List<DocumentTreeNode> getTreeRoots() throws ClientException {
        if (this.tree == null) {
            this.tree = new ArrayList<DocumentTreeNode>();
            DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
            DocumentModel firstAccessibleParent = null;
            if (currentDocument != null) {
                List parents = this.documentManager.getParentDocuments(currentDocument.getRef());
                if (!parents.isEmpty()) {
                    firstAccessibleParent = (DocumentModel)parents.get(0);
                } else if (!"Root".equals(currentDocument.getType()) && currentDocument.isFolder()) {
                    firstAccessibleParent = currentDocument;
                }
            }
            if (firstAccessibleParent != null) {
                Filter filter = null;
                Filter leafFilter = null;
                Sorter sorter = null;
                QueryModel queryModel = null;
                try {
                    TreeManager treeManager = (TreeManager)Framework.getService(TreeManager.class);
                    filter = treeManager.getFilter("navigation");
                    leafFilter = treeManager.getLeafFilter("navigation");
                    sorter = treeManager.getSorter("navigation");
                    QueryModelDescriptor queryModelDescriptor = treeManager.getQueryModelDescriptor("navigation");
                    queryModel = queryModelDescriptor == null ? null : new QueryModel(queryModelDescriptor);
                }
                catch (Exception e) {
                    log.error((Object)"Could not fetch filter, sorter or node type for tree ", (Throwable)e);
                }
                DocumentTreeNodeImpl treeRoot = new DocumentTreeNodeImpl(firstAccessibleParent, filter, leafFilter, sorter, queryModel);
                this.tree.add(treeRoot);
                log.debug((Object)("Tree initialized with document: " + firstAccessibleParent.getId()));
            } else {
                log.debug((Object)"Could not initialize the navigation tree: no parent found for current document");
            }
        }
        return this.tree;
    }

    @Override
    public void changeExpandListener(NodeExpandedEvent event) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        requestMap.put(NODE_SELECTED_MARKER, Boolean.TRUE);
    }

    protected Boolean isNodeExpandEvent() {
        ExternalContext externalContext;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (facesContext != null && (externalContext = facesContext.getExternalContext()) != null) {
            return Boolean.TRUE.equals(externalContext.getRequestMap().get(NODE_SELECTED_MARKER));
        }
        return false;
    }

    protected String getCurrentDocumentPath() {
        DocumentModel currentDoc;
        if (this.currentDocumentPath == null && (currentDoc = this.navigationContext.getCurrentDocument()) != null) {
            this.currentDocumentPath = currentDoc.getPathAsString();
        }
        return this.currentDocumentPath;
    }

    @Override
    public Boolean adviseNodeOpened(UITree treeComponent) {
        Object value;
        if (!this.isNodeExpandEvent().booleanValue() && (value = treeComponent.getRowData()) instanceof DocumentTreeNode) {
            DocumentTreeNode treeNode = (DocumentTreeNode)value;
            String nodePath = treeNode.getPath();
            String currentDocPath = this.getCurrentDocumentPath();
            if (currentDocPath != null && nodePath != null && currentDocPath.startsWith(nodePath) && (currentDocPath + '/').startsWith(nodePath + '/')) {
                return true;
            }
        }
        return null;
    }

    @Override
    @Observer(value={"userAllDocumentTypesSelectionChanged"}, create=false)
    @BypassInterceptors
    public void resetCurrentDocumentData() {
        this.currentDocumentPath = null;
        if (this.tree != null && this.tree.isEmpty()) {
            this.tree = null;
        }
    }

    @Override
    @Observer(value={"goHome", "domainSelectionChanged", "documentChanged", "documentSecurityChanged", "documentChildrenChanged"}, create=false)
    @BypassInterceptors
    public void reset() {
        this.tree = null;
        this.resetCurrentDocumentData();
    }

    @Override
    @Destroy
    @Remove
    public void destroy() {
        log.debug((Object)"Removing SEAM component...");
    }
}

