/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.schema.types;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.ecm.core.schema.TypeRef;
import org.nuxeo.ecm.core.schema.types.AbstractType;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.FieldImpl;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.QName;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.TypeException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListTypeImpl
extends AbstractType
implements ListType {
    private static final long serialVersionUID = 6443946870580167862L;
    protected static final String DEFAULT_VALUE_SEPARATOR = " ";
    protected final TypeRef<? extends Type> type;
    protected final Field field;
    protected String defaultValue;
    protected int minOccurs;
    protected int maxOccurs;
    protected boolean isArray = false;

    public ListTypeImpl(String schema, String name, TypeRef<? extends Type> type, String fieldName, String defaultValue, int minOccurs, int maxOccurs) {
        super(null, schema, name);
        if (fieldName == null) {
            this.isArray = true;
            fieldName = "item";
        }
        this.type = type;
        this.field = new FieldImpl(QName.valueOf(fieldName), this.getRef(), type);
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
        this.defaultValue = defaultValue;
    }

    public ListTypeImpl(String schema, String name, Type type) {
        this(schema, name, type.getRef(), null, null, 0, -1);
    }

    public ListTypeImpl(String schema, String name, Type type, String defaultValue) {
        this(schema, name, type.getRef(), null, defaultValue, 0, -1);
    }

    public ListTypeImpl(String schema, String name, Type type, String fieldName, String defaultValue, int minOccurs, int maxOccurs) {
        this(schema, name, type.getRef(), fieldName, defaultValue, minOccurs, maxOccurs);
    }

    public ListTypeImpl(String schema, String name, TypeRef<? extends Type> type) {
        this(schema, name, type, null, null, 0, -1);
    }

    public ListTypeImpl(String schema, String name, TypeRef<? extends Type> type, String defaultValue) {
        this(schema, name, type, null, defaultValue, 0, -1);
    }

    @Override
    public void setLimits(int minOccurs, int maxOccurs) {
        this.minOccurs = minOccurs;
        this.maxOccurs = maxOccurs;
    }

    @Override
    public void setDefaultValue(String value) {
        this.defaultValue = value;
    }

    @Override
    public String getFieldName() {
        return this.field.getName().getLocalName();
    }

    @Override
    public Type getFieldType() {
        return this.field.getType();
    }

    @Override
    public Field getField() {
        return this.field;
    }

    @Override
    public Object getDefaultValue() {
        return this.type.get().decode(this.defaultValue);
    }

    public Type getType() {
        return this.type.get();
    }

    @Override
    public int getMinCount() {
        return this.minOccurs;
    }

    @Override
    public int getMaxCount() {
        return this.maxOccurs;
    }

    @Override
    public boolean isListType() {
        return true;
    }

    @Override
    public Object decode(String string) {
        if (string != null) {
            ArrayList<Object> decoded = new ArrayList<Object>();
            Type t = this.type.get();
            for (String component : string.split(DEFAULT_VALUE_SEPARATOR)) {
                decoded.add(t.decode(component));
            }
            return decoded;
        }
        return null;
    }

    @Override
    public boolean validate(Object object) throws TypeException {
        if (object == null && this.isNotNull()) {
            return false;
        }
        if (object == null) {
            return true;
        }
        if (object instanceof Collection) {
            return this.validateCollection((Collection)object);
        }
        if (object.getClass().isArray()) {
            return this.validateArray((Object[])object);
        }
        return false;
    }

    protected boolean validateArray(Object[] array) {
        return true;
    }

    protected boolean validateCollection(Collection col) {
        return true;
    }

    @Override
    public Object newInstance() {
        String defaultValue = this.defaultValue;
        if (defaultValue != null) {
            return defaultValue;
        }
        return new ArrayList();
    }

    @Override
    public Object convert(Object object) throws TypeException {
        if (object instanceof List) {
            List list = (List)object;
            Type t = this.type.get();
            int len = list.size();
            for (int i = 0; i < len; ++i) {
                Object value = list.get(i);
                list.set(i, t.convert(value));
            }
            return object;
        }
        throw new TypeException("Incompatible object: " + object.getClass() + " for type " + this.getName());
    }

    @Override
    public TypeRef<ListType> getRef() {
        return new TypeRef<ListType>(this.schema, this.name, this);
    }

    @Override
    public boolean isArray() {
        return this.isArray;
    }

    @Override
    public boolean isScalarList() {
        return this.field.getType().isSimpleType();
    }
}

