/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.nuxeo.common.collections.ScopeType;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.filemanager.service.FileManagerService;
import org.nuxeo.ecm.platform.filemanager.service.extension.FileImporter;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.ecm.platform.versioning.api.VersioningActions;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractFileImporter
implements FileImporter {
    private static final long serialVersionUID = 1L;
    protected String name = "";
    protected List<String> filters = new ArrayList<String>();
    protected List<Pattern> patterns;
    protected boolean enabled = true;
    protected Integer order = 0;
    protected FileManagerService fileManagerService;

    @Override
    public List<String> getFilters() {
        return this.filters;
    }

    @Override
    public void setFilters(List<String> filters) {
        this.filters = filters;
        this.patterns = new ArrayList<Pattern>();
        for (String filter : filters) {
            this.patterns.add(Pattern.compile(filter));
        }
    }

    @Override
    public boolean matches(String mimeType) {
        for (Pattern pattern : this.patterns) {
            if (!pattern.matcher(mimeType).matches()) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public DocumentModel create(CoreSession documentManager, File file, String path, boolean overwrite, String mimeType, TypeManager typService) {
        return null;
    }

    public FileManagerService getFileManagerService() {
        return this.fileManagerService;
    }

    @Override
    public void setFileManagerService(FileManagerService fileManagerService) {
        this.fileManagerService = fileManagerService;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    @Override
    public Integer getOrder() {
        return this.order;
    }

    @Override
    public void setOrder(Integer order) {
        this.order = order;
    }

    @Override
    public int compareTo(FileImporter other) {
        Integer otherOrder = other.getOrder();
        if (this.order == null && otherOrder == null) {
            return 0;
        }
        if (this.order == null) {
            return 1;
        }
        if (otherOrder == null) {
            return -1;
        }
        return this.order.compareTo(otherOrder);
    }

    protected TypeManager getTypeService() throws ClientException {
        try {
            return (TypeManager)Framework.getService(TypeManager.class);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
    }

    protected String getNearestContainerPath(CoreSession documentManager, String path) throws ClientException {
        DocumentModel currentDocument = documentManager.getDocument((DocumentRef)new PathRef(path));
        if (!currentDocument.isFolder()) {
            path = path.substring(0, path.lastIndexOf(47));
        }
        return path;
    }

    protected DocumentModel overwriteAndIncrementversion(CoreSession documentManager, DocumentModel doc) throws ClientException {
        doc.putContextData(ScopeType.REQUEST, "CREATE_SNAPSHOT_ON_SAVE", (Serializable)Boolean.valueOf(true));
        doc.putContextData(ScopeType.REQUEST, "VersioningOption", (Serializable)VersioningActions.ACTION_INCREMENT_MINOR);
        return documentManager.saveDocument(doc);
    }
}

