/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.service.extension;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.ExportedDocument;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.DocumentModelWriter;
import org.nuxeo.ecm.core.io.impl.plugins.NuxeoArchiveReader;
import org.nuxeo.ecm.platform.filemanager.service.extension.AbstractFileImporter;
import org.nuxeo.ecm.platform.types.TypeManager;

public class ExportedZipImporter
extends AbstractFileImporter {
    private static final long serialVersionUID = 1876876876L;
    private static final Log log = LogFactory.getLog(ExportedZipImporter.class);

    public static ZipFile getArchiveFileIfValid(File file) throws IOException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(file);
        }
        catch (ZipException e) {
            log.debug((Object)"file is not a zipfile ! ", (Throwable)e);
            return null;
        }
        catch (IOException e) {
            log.debug((Object)"can not open zipfile ! ", (Throwable)e);
            return null;
        }
        ZipEntry marker = zip.getEntry(".nuxeo-archive");
        if (marker == null) {
            zip.close();
            return null;
        }
        return zip;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DocumentModel create(CoreSession documentManager, Blob content, String path, boolean overwrite, String filename, TypeManager typeService) throws ClientException, IOException {
        DocumentModel target;
        File tmp = File.createTempFile("xml-importer", null);
        content.transferTo(tmp);
        ZipFile zip = ExportedZipImporter.getArchiveFileIfValid(tmp);
        if (zip == null) {
            tmp.delete();
            return null;
        }
        IdRef resultingRef = null;
        DocumentModelWriter writer = null;
        boolean importWithIds = false;
        NuxeoArchiveReader reader = new NuxeoArchiveReader(tmp);
        ExportedDocument root = reader.read();
        IdRef rootRef = new IdRef(root.getId());
        if (documentManager.exists((DocumentRef)rootRef) && (target = documentManager.getDocument((DocumentRef)rootRef)).getPath().removeLastSegments(1).equals((Object)new Path(path))) {
            importWithIds = true;
        }
        writer = new DocumentModelWriter(documentManager, path, 10);
        reader.close();
        reader = new NuxeoArchiveReader(tmp);
        if (overwrite && importWithIds) {
            resultingRef = rootRef;
        } else {
            String rootName = root.getPath().lastSegment();
            resultingRef = new PathRef(path + "/" + rootName);
        }
        try {
            DocumentPipeImpl pipe = new DocumentPipeImpl(10);
            pipe.setReader((DocumentReader)reader);
            pipe.setWriter((DocumentWriter)writer);
            pipe.run();
        }
        catch (Exception e) {
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        tmp.delete();
        if (resultingRef != null) {
            return documentManager.getDocument((DocumentRef)resultingRef);
        }
        return null;
    }
}

