/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.ui.web.directory.ChainSelectBase;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryEntry;

public class ChainSelectOne
extends ChainSelectBase {
    public void decode(FacesContext context) {
        if (this.getDisplayValueOnly()) {
            return;
        }
        this.decodeSelection(context);
        this.setValid(true);
        this.setSubmittedValue(this.getValueAsString(this.getSelection()));
    }

    public String[] getSelection() {
        String clientId = this.getClientId(FacesContext.getCurrentInstance());
        String[] selection = (String[])this.selectionMap.get(clientId);
        if (selection == null) {
            selection = this.getValueAsArray((String)this.getValue());
            this.selectionMap.put(clientId, selection);
        }
        return selection;
    }

    public void encodeBegin(FacesContext context) throws IOException {
        this.getChildren().clear();
        if (this.getDisplayValueOnly()) {
            this.encodeReadOnly(context);
        } else {
            this.encodeReadWrite(context);
        }
    }

    public void encodeReadOnly(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String value = (String)this.getSubmittedValue();
        if (value == null) {
            value = (String)this.getValue();
        }
        if (value != null) {
            String[] keys = StringUtils.split((String)value, (String)this.getKeySeparator());
            List<DirectoryEntry> nodes = this.resolveKeys(keys);
            ArrayList<String> labels = new ArrayList<String>();
            for (DirectoryEntry node : nodes) {
                String itemValue = node.getId();
                String itemLabel = node.getLabel();
                itemLabel = this.computeItemLabel(context, itemValue, itemLabel);
                labels.add(itemLabel);
            }
            String concatenatedLabel = StringUtils.join(labels.iterator(), (String)this.getKeySeparator());
            writer.startElement("div", (UIComponent)this);
            writer.write(concatenatedLabel);
            writer.endElement("div");
        }
    }

    public void encodeReadWrite(FacesContext context) throws IOException {
        String styleClass;
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)this);
        writer.writeAttribute("id", (Object)this.getClientId(context), "id");
        String style = this.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        if ((styleClass = this.getStyleClass()) != null) {
            writer.writeAttribute("class", (Object)styleClass, "class");
        }
        String[] selectedKeys = this.getSelection();
        for (int level = 0; level < this.getDepth(); ++level) {
            this.encodeListbox(context, level, selectedKeys);
        }
        writer.endElement("div");
    }

    public void validateValue(FacesContext context, Object newValue) {
        super.validateValue(context, newValue);
        if (newValue == null || !this.isValid()) {
            return;
        }
        String[] keys = this.getValueAsArray((String)newValue);
        this.validateEntry(context, keys);
    }

    public String getFamily() {
        return "nxdirectory.ChainSelectOne";
    }

    public String getRendererType() {
        return null;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context)};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
    }
}

