/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItem;
import org.nuxeo.ecm.platform.ui.web.directory.SelectItemComparator;
import org.nuxeo.ecm.platform.ui.web.directory.VocabularyEntryList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DirectoryAwareComponent
extends UIInput {
    protected String directoryName;
    protected Map<String, SelectItem> options;
    protected Boolean displayIdAndLabel;
    protected Boolean displayObsoleteEntries;
    protected Boolean localize;
    protected Boolean notDisplayDefaultOption;
    protected Boolean displayValueOnly;
    protected String displayValueOnlyStyle;
    protected String displayValueOnlyStyleClass;
    protected String display;
    protected String onchange;
    protected String filter;
    protected String size;
    protected String ordering;
    protected VocabularyEntryList directoryValues;
    protected Boolean caseSensitive;

    protected String getStringValue(String name, String defaultValue) {
        ValueExpression ve = this.getValueExpression(name);
        if (ve != null) {
            try {
                return (String)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return defaultValue;
    }

    protected Boolean getBooleanValue(String name, boolean defaultValue) {
        ValueExpression ve = this.getValueExpression(name);
        if (ve != null) {
            try {
                return !Boolean.FALSE.equals(ve.getValue(this.getFacesContext().getELContext()));
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return defaultValue;
    }

    public String getDirectoryName() {
        if (this.directoryName != null) {
            return this.directoryName;
        }
        return this.getStringValue("directoryName", null);
    }

    public void setDirectoryName(String directoryName) {
        this.directoryName = directoryName;
    }

    public Boolean getDisplayIdAndLabel() {
        if (this.displayIdAndLabel != null) {
            return this.displayIdAndLabel;
        }
        return this.getBooleanValue("displayIdAndLabel", false);
    }

    public void setDisplayIdAndLabel(Boolean displayIdAndLabel) {
        this.displayIdAndLabel = displayIdAndLabel;
    }

    public Boolean getLocalize() {
        if (this.localize != null) {
            return this.localize;
        }
        return this.getBooleanValue("localize", false);
    }

    public void setLocalize(Boolean localize) {
        this.localize = localize;
    }

    public Boolean getCaseSensitive() {
        if (this.caseSensitive != null) {
            return this.caseSensitive;
        }
        return this.getBooleanValue("caseSensitive", false);
    }

    public void setCaseSensitive(Boolean caseSensitive) {
        this.caseSensitive = caseSensitive;
    }

    public Map<String, SelectItem> getOptions() {
        VocabularyEntryList directoryValues = this.getDirectoryValues();
        String directoryName = this.getDirectoryName();
        this.options = new LinkedHashMap<String, SelectItem>();
        if (StringUtils.isEmpty((String)directoryName) && directoryValues == null) {
            return this.options;
        }
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        String parentFilter = this.getFilter();
        if (parentFilter != null) {
            filter.put("parent", (Serializable)((Object)parentFilter));
        }
        if (!this.getDisplayObsoleteEntries().booleanValue()) {
            filter.put("obsolete", Integer.valueOf(0));
        }
        List<Object> optionList = !StringUtils.isEmpty((String)directoryName) ? DirectoryHelper.instance().getSelectItems(directoryName, filter, this.localize) : (directoryValues != null ? DirectoryHelper.getSelectItems(directoryValues, filter, this.localize) : new ArrayList());
        String ordering = this.getOrdering();
        Boolean caseSensitive = this.getCaseSensitive();
        if (ordering != null && !"".equals(ordering)) {
            Collections.sort(optionList, new SelectItemComparator(ordering, caseSensitive));
        }
        for (DirectorySelectItem item : optionList) {
            this.options.put((String)item.getValue(), item);
        }
        return this.options;
    }

    public void setOptions(Map<String, SelectItem> options) {
        this.options = options;
    }

    public Boolean getDisplayObsoleteEntries() {
        if (this.displayObsoleteEntries != null) {
            return this.displayObsoleteEntries;
        }
        return this.getBooleanValue("displayObsoleteEntries", false);
    }

    public void setDisplayObsoleteEntries(Boolean displayObsoleteEntries) {
        this.displayObsoleteEntries = displayObsoleteEntries;
    }

    public Boolean getNotDisplayDefaultOption() {
        if (this.notDisplayDefaultOption != null) {
            return this.notDisplayDefaultOption;
        }
        return this.getBooleanValue("notDisplauDefaultOption", false);
    }

    public void setNotDisplayDefaultOption(Boolean notDisplayDefaultOption) {
        this.notDisplayDefaultOption = notDisplayDefaultOption;
    }

    public Boolean getDisplayValueOnly() {
        if (this.displayValueOnly != null) {
            return this.displayValueOnly;
        }
        return this.getBooleanValue("displayValueOnly", false);
    }

    public void setDisplayValueOnly(Boolean displayValueOnly) {
        this.displayValueOnly = displayValueOnly;
    }

    public String getDisplayValueOnlyStyle() {
        if (this.displayValueOnlyStyle != null) {
            return this.displayValueOnlyStyle;
        }
        return this.getStringValue("displayValueOnlyStyle", null);
    }

    public void setDisplayValueOnlyStyle(String displayValueOnlyStyle) {
        this.displayValueOnlyStyle = displayValueOnlyStyle;
    }

    public String getDisplayValueOnlyStyleClass() {
        if (this.displayValueOnlyStyleClass != null) {
            return this.displayValueOnlyStyleClass;
        }
        return this.getStringValue("displayValueOnlyStyleClass", null);
    }

    public void setDisplayValueOnlyStyleClass(String displayValueOnlyStyleClass) {
        this.displayValueOnlyStyleClass = displayValueOnlyStyleClass;
    }

    public String getDisplay() {
        if (this.display != null) {
            return this.display;
        }
        return this.getStringValue("display", null);
    }

    public void setDisplay(String display) {
        this.display = display;
    }

    public String getOnchange() {
        if (this.onchange != null) {
            return this.onchange;
        }
        return this.getStringValue("onchange", null);
    }

    public void setOnchange(String onchange) {
        this.onchange = onchange;
    }

    public String getFilter() {
        if (this.filter != null) {
            return this.filter;
        }
        return this.getStringValue("filter", null);
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public String getSize() {
        if (this.size != null) {
            return this.size;
        }
        return this.getStringValue("size", null);
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getOrdering() {
        if (this.ordering != null) {
            return this.ordering;
        }
        return this.getStringValue("ordering", null);
    }

    public void setOrdering(String ordering) {
        this.ordering = ordering;
    }

    public VocabularyEntryList getDirectoryValues() {
        ValueExpression ve = this.getValueExpression("directoryValues");
        if (ve != null) {
            try {
                return (VocabularyEntryList)ve.getValue(this.getFacesContext().getELContext());
            }
            catch (ELException e) {
                throw new FacesException((Throwable)e);
            }
        }
        return null;
    }

    public void setDirectoryValues(VocabularyEntryList directoryValues) {
        this.directoryValues = directoryValues;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this.directoryName, this.options, this.displayIdAndLabel, this.displayObsoleteEntries, this.localize, this.notDisplayDefaultOption, this.displayValueOnly, this.displayValueOnlyStyle, this.displayValueOnlyStyleClass, this.display, this.onchange, this.filter, this.size, this.ordering, this.directoryValues, this.caseSensitive};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.directoryName = (String)values[1];
        this.options = (Map)values[2];
        this.displayIdAndLabel = (Boolean)values[3];
        this.displayObsoleteEntries = (Boolean)values[4];
        this.localize = (Boolean)values[5];
        this.notDisplayDefaultOption = (Boolean)values[6];
        this.displayValueOnly = (Boolean)values[7];
        this.displayValueOnlyStyle = (String)values[8];
        this.displayValueOnlyStyleClass = (String)values[9];
        this.display = (String)values[10];
        this.onchange = (String)values[11];
        this.filter = (String)values[12];
        this.size = (String)values[13];
        this.ordering = (String)values[14];
        this.directoryValues = (VocabularyEntryList)values[15];
        this.caseSensitive = (Boolean)values[16];
    }

    public Boolean getBooleanProperty(String key, Boolean defaultValue) {
        Map map = this.getAttributes();
        Boolean value = (Boolean)map.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }

    public String getStringProperty(String key, String defaultValue) {
        Map map = this.getAttributes();
        String value = (String)map.get(key);
        if (value == null) {
            value = defaultValue;
        }
        return value;
    }
}

