/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.faces.context.FacesContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.DirectoryException;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.ui.web.directory.DirectorySelectItem;
import org.nuxeo.ecm.platform.ui.web.directory.VocabularyEntry;
import org.nuxeo.ecm.platform.ui.web.directory.VocabularyEntryList;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DirectoryHelper {
    private static final Log log = LogFactory.getLog(DirectoryHelper.class);
    public static final String XVOCABULARY_TYPE = "xvocabulary";
    public static final String[] VOCABULARY_TYPES = new String[]{"vocabulary", "xvocabulary"};
    private static final String[] displayOptions = new String[]{"id", "label", "idAndLabel"};
    private static DirectoryHelper instance;
    private static DirectoryService service;

    private DirectoryHelper() {
    }

    public static DirectoryHelper instance() {
        if (null == instance) {
            instance = new DirectoryHelper();
        }
        return instance;
    }

    public boolean hasParentColumn(String directoryName) {
        try {
            return XVOCABULARY_TYPE.equals(this.getService().getDirectorySchema(directoryName));
        }
        catch (DirectoryException e) {
            log.error((Object)("Could not retrieve schema name for directory: " + directoryName), (Throwable)e);
            return false;
        }
    }

    public DirectorySelectItem getSelectItem(String directoryName, Map<String, Serializable> filter) {
        List<DirectorySelectItem> items = this.getSelectItems(directoryName, filter);
        if (items.size() > 1) {
            log.warn((Object)("More than one entry found in directory " + directoryName + " and filter:"));
            for (Map.Entry<String, Serializable> e : filter.entrySet()) {
                log.warn((Object)String.format("%s=%s", e.getKey(), e.getValue()));
            }
        } else if (items.isEmpty()) {
            return null;
        }
        return items.get(0);
    }

    public List<DirectorySelectItem> getSelectItems(String directoryName, Map<String, Serializable> filter) {
        return this.getSelectItems(directoryName, filter, Boolean.FALSE);
    }

    public List<DirectorySelectItem> getSelectItems(String directoryName, Map<String, Serializable> filter, Boolean localize) {
        LinkedList<DirectorySelectItem> list = new LinkedList<DirectorySelectItem>();
        Set emptySet = Collections.emptySet();
        LinkedHashMap<String, String> orderBy = new LinkedHashMap<String, String>();
        FacesContext context = FacesContext.getCurrentInstance();
        Session session = null;
        try {
            String schema = this.getService().getDirectorySchema(directoryName);
            session = this.getService().open(directoryName);
            if (session == null) {
                throw new ClientException("could not open session on directory: " + directoryName);
            }
            if (schema.equals(VOCABULARY_TYPES[0]) || schema.equals(VOCABULARY_TYPES[1])) {
                orderBy.put("ordering", "asc");
                orderBy.put("id", "asc");
            }
            DocumentModelList docModelList = session.query(filter, emptySet, orderBy);
            for (DocumentModel docModel : docModelList) {
                String id = (String)docModel.getProperty(schema, "id");
                String label = (String)docModel.getProperty(schema, "label");
                if (Boolean.TRUE.equals(localize)) {
                    label = DirectoryHelper.translate(context, label);
                }
                DirectorySelectItem item = new DirectorySelectItem(id, label);
                list.add(item);
            }
        }
        catch (ClientException e) {
            throw new RuntimeException("failed to build option list for directory " + directoryName, e);
        }
        finally {
            try {
                if (session != null) {
                    session.close();
                }
            }
            catch (ClientException ce) {
                log.error((Object)"Could not close directory session", (Throwable)ce);
            }
        }
        return list;
    }

    public static DirectoryService getDirectoryService() {
        return DirectoryHelper.instance().getService();
    }

    public static List<DirectorySelectItem> getSelectItems(VocabularyEntryList directoryValues, Map<String, Serializable> filter) {
        return DirectoryHelper.getSelectItems(directoryValues, filter, Boolean.FALSE);
    }

    public static List<DirectorySelectItem> getSelectItems(VocabularyEntryList directoryValues, Map<String, Serializable> filter, Boolean localize) {
        ArrayList<DirectorySelectItem> list = new ArrayList<DirectorySelectItem>();
        boolean obsolete = filter.get("obsolete") == null;
        String parentFilter = (String)((Object)filter.get("parent"));
        FacesContext context = FacesContext.getCurrentInstance();
        for (VocabularyEntry entry : directoryValues.getEntries()) {
            if (!obsolete && Boolean.TRUE.equals(entry.getObsolete())) continue;
            String parent = entry.getParent();
            if (parentFilter != null ? !parentFilter.equals(parent) : parent != null) continue;
            String idValue = (String)((Object)filter.get("id"));
            if (idValue != null && !idValue.equals(entry.getId())) continue;
            String id = entry.getId();
            String label = entry.getLabel();
            if (Boolean.TRUE.equals(localize)) {
                label = DirectoryHelper.translate(context, label);
            }
            DirectorySelectItem item = new DirectorySelectItem(id, label);
            list.add(item);
        }
        return list;
    }

    public static String getOptionValue(String optionId, String optionLabel, String display, boolean displayIdAndLabel, String displayIdAndLabelSeparator) {
        StringBuilder displayValue = new StringBuilder();
        if (display != null && !"".equals(display)) {
            if (display.equals(displayOptions[0])) {
                displayValue.append(optionId);
            } else if (display.equals(displayOptions[1])) {
                displayValue.append(optionLabel);
            } else if (display.equals(displayOptions[2])) {
                displayValue.append(optionId).append(displayIdAndLabelSeparator).append(optionLabel);
            } else {
                displayValue.append(optionLabel);
            }
        } else if (displayIdAndLabel) {
            displayValue.append(optionId).append(displayIdAndLabelSeparator).append(optionLabel);
        } else {
            displayValue.append(optionLabel);
        }
        return displayValue.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DocumentModel getEntryThrows(String directoryName, String entryId) throws ClientException {
        DocumentModel entry;
        DirectoryService dirService = DirectoryHelper.getDirectoryService();
        if (dirService == null) {
            throw new ClientException("Could not lookup DirectoryService");
        }
        Session session = dirService.open(directoryName);
        try {
            entry = session.getEntry(entryId);
        }
        finally {
            try {
                session.close();
            }
            catch (ClientException e) {
                log.warn((Object)("Could not close a session on directory " + directoryName), (Throwable)e);
            }
        }
        return entry;
    }

    public static DocumentModel getEntry(String directoryName, String entryId) {
        try {
            return DirectoryHelper.getEntryThrows(directoryName, entryId);
        }
        catch (ClientException e) {
            log.error((Object)String.format("Error retrieving the entry (dirname=%s, entryId=%s)", directoryName, entryId), (Throwable)e);
            return null;
        }
    }

    protected static String translate(FacesContext context, String label) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        label = I18NUtils.getMessageString((String)bundleName, (String)label, null, (Locale)locale);
        return label;
    }

    protected DirectoryService getService() {
        if (service == null) {
            DirectoryService dirService = (DirectoryService)Framework.getLocalService(DirectoryService.class);
            if (dirService == null) {
                try {
                    dirService = (DirectoryService)Framework.getService(DirectoryService.class);
                }
                catch (Exception e) {
                    log.error((Object)"Can't find Directory Service", (Throwable)e);
                }
            } else {
                return dirService;
            }
            service = dirService;
        }
        return service;
    }
}

