/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.platform.ui.web.directory.SelectManyListboxComponent;

public class SelectManyListboxRenderer
extends Renderer {
    private static final Log log = LogFactory.getLog(SelectManyListboxRenderer.class);

    public SelectManyListboxRenderer() {
        log.trace((Object)"renderer created");
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        SelectManyListboxComponent comp = (SelectManyListboxComponent)component;
        String clientId = comp.getClientId(facesContext);
        if (SelectManyListboxRenderer.componentReadonly(comp)) {
            return;
        }
        Map requestMap = facesContext.getExternalContext().getRequestParameterValuesMap();
        String[] value = null;
        if (requestMap.containsKey(clientId)) {
            value = (String[])requestMap.get(clientId);
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(value));
            list.remove("");
            value = list.toArray(new String[list.size()]);
        } else {
            value = new String[]{};
        }
        ((UIInput)component).setSubmittedValue((Object)value);
    }

    private static boolean componentReadonly(SelectManyListboxComponent comp) {
        return comp.getDisplayValueOnly();
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        SelectManyListboxComponent comp = (SelectManyListboxComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        boolean displayValueOnly = comp.getDisplayValueOnly();
        if (displayValueOnly) {
            SelectManyListboxRenderer.encodeInputAsText(context, writer, comp);
        } else {
            SelectManyListboxRenderer.encodeInput(context, writer, comp);
        }
    }

    private static void encodeInputAsText(FacesContext context, ResponseWriter writer, SelectManyListboxComponent comp) throws IOException {
        String displayValueOnlyStyle = comp.getDisplayValueOnlyStyle();
        String displayValueOnlyStyleClass = comp.getDisplayValueOnlyStyleClass();
        String displayValueOnlySeparator = comp.getDisplayValueOnlySeparator();
        Boolean localize = comp.getLocalize();
        Boolean displayIdAndLabel = comp.getDisplayIdAndLabel();
        String display = comp.getDisplay();
        String id = comp.getClientId(context);
        writer.startElement("div", (UIComponent)comp);
        String[] selectedOptions = SelectManyListboxRenderer.getCurrentSelectedValues((UIComponent)comp);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, "id");
        }
        if (displayValueOnlyStyle != null) {
            writer.writeAttribute("style", (Object)displayValueOnlyStyle, "style");
        }
        if (displayValueOnlyStyleClass != null) {
            writer.writeAttribute("class", (Object)displayValueOnlyStyleClass, "class");
        }
        Map<String, SelectItem> options = comp.getOptions();
        if (selectedOptions != null) {
            int index = 0;
            for (String selectedOption : selectedOptions) {
                SelectItem item = options.get(selectedOption);
                if (item == null) continue;
                String optionId = (String)item.getValue();
                String optionLabel = item.getLabel();
                if (localize.booleanValue()) {
                    optionLabel = SelectManyListboxRenderer.translate(context, optionLabel);
                }
                String displayValue = DirectoryHelper.getOptionValue(optionId, optionLabel, display, displayIdAndLabel, " ");
                writer.startElement("div", (UIComponent)comp);
                writer.writeText((Object)displayValue, null);
                writer.endElement("div");
                if (displayValueOnlySeparator == null || ++index >= selectedOptions.length) continue;
                writer.writeText((Object)displayValueOnlySeparator, null);
            }
        }
        writer.endElement("div");
    }

    private static void encodeInput(FacesContext context, ResponseWriter writer, SelectManyListboxComponent comp) throws IOException {
        String cssStyleClass = comp.getStringProperty("cssStyleClass", null);
        String cssStyle = comp.getStringProperty("cssStyle", null);
        String id = comp.getClientId(context);
        Boolean localize = comp.getLocalize();
        Boolean displayIdAndLabel = comp.getDisplayIdAndLabel();
        String display = comp.getDisplay();
        display = display == null ? "" : display;
        String size = comp.getSize();
        size = size == null ? "5" : size;
        String onchange = comp.getOnchange();
        writer.startElement("select", (UIComponent)comp);
        writer.writeAttribute("name", (Object)id, "name");
        writer.writeAttribute("size", (Object)size, "size");
        writer.writeAttribute("multiple", (Object)"true", "multiple");
        if (id != null) {
            writer.writeAttribute("id", (Object)id, "id");
        }
        if (cssStyleClass != null) {
            writer.writeAttribute("class", (Object)cssStyleClass, "class");
        }
        if (cssStyle != null) {
            writer.writeAttribute("style", (Object)cssStyle, "style");
        }
        if (onchange != null) {
            writer.writeAttribute("onchange", (Object)onchange, "onchange");
        }
        Map<String, SelectItem> options = comp.getOptions();
        String[] selectedValues = SelectManyListboxRenderer.getCurrentSelectedValues((UIComponent)comp);
        ArrayList<SelectItem> newOptions = new ArrayList<SelectItem>();
        if (!comp.getNotDisplayDefaultOption().booleanValue()) {
            SelectManyListboxRenderer.displayDefaultOption(context, writer);
        }
        for (SelectItem item : options.values()) {
            String optionId = (String)item.getValue();
            String optionLabel = item.getLabel();
            if (localize.booleanValue()) {
                optionLabel = SelectManyListboxRenderer.translate(context, optionLabel);
            }
            SelectItem newItem = new SelectItem((Object)optionId, optionLabel);
            newOptions.add(newItem);
        }
        HashSet<String> selectedValuesSet = new HashSet<String>();
        if (selectedValues != null) {
            selectedValuesSet.addAll(Arrays.asList(selectedValues));
        }
        for (SelectItem item : newOptions) {
            String optionId = (String)item.getValue();
            String optionLabel = item.getLabel();
            String displayValue = DirectoryHelper.getOptionValue(optionId, optionLabel, display, displayIdAndLabel, " ");
            writer.startElement("option", (UIComponent)comp);
            writer.writeAttribute("value", (Object)optionId, "value");
            boolean selected = selectedValuesSet.contains(optionId);
            if (selected) {
                writer.writeAttribute("selected", (Object)"true", "selected");
            }
            writer.writeText((Object)displayValue, null);
            writer.endElement("option");
        }
        writer.endElement("select");
    }

    protected static String[] getCurrentSelectedValues(UIComponent component) {
        Object submittedValue;
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            return SelectManyListboxRenderer.toArray(submittedValue);
        }
        if (component instanceof ValueHolder) {
            Object value = ((ValueHolder)component).getValue();
            return SelectManyListboxRenderer.toArray(value);
        }
        return null;
    }

    private static String[] toArray(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String[]) {
            return (String[])value;
        }
        if (value instanceof Object[]) {
            Object[] ar = (Object[])value;
            String[] ret = new String[ar.length];
            System.arraycopy(ar, 0, ret, 0, ar.length);
            return ret;
        }
        assert (value instanceof List);
        List list = (List)value;
        return list.toArray(new String[list.size()]);
    }

    private static void displayDefaultOption(FacesContext context, ResponseWriter writer) throws IOException {
        String defaultLabel = SelectManyListboxRenderer.translate(context, "label.vocabulary.selectValue");
        writer.startElement("option", null);
        writer.writeAttribute("value", (Object)"", "value");
        writer.writeText((Object)defaultLabel, null);
        writer.endElement("option");
    }

    protected static String translate(FacesContext context, String label) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        label = I18NUtils.getMessageString((String)bundleName, (String)label, null, (Locale)locale);
        return label;
    }
}

