/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.directory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import javax.faces.component.EditableValueHolder;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.ValueHolder;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.model.SelectItem;
import javax.faces.render.Renderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.platform.ui.web.directory.DirectoryHelper;
import org.nuxeo.ecm.platform.ui.web.directory.SelectOneListboxComponent;

public class SelectOneListboxRenderer
extends Renderer {
    private static final Log log = LogFactory.getLog(SelectOneListboxRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        SelectOneListboxComponent comp = (SelectOneListboxComponent)component;
        if (comp.getDisplayValueOnly().booleanValue()) {
            return;
        }
        String id = comp.getClientId(facesContext);
        Map requestMap = facesContext.getExternalContext().getRequestParameterMap();
        String value = (String)requestMap.get(id);
        if (value == null) {
            value = "";
        }
        ((UIInput)component).setSubmittedValue((Object)value);
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        SelectOneListboxComponent comp = (SelectOneListboxComponent)component;
        ResponseWriter writer = context.getResponseWriter();
        boolean displayValueOnly = comp.getDisplayValueOnly();
        if (displayValueOnly) {
            SelectOneListboxRenderer.encodeInputAsText(context, writer, comp);
        } else {
            SelectOneListboxRenderer.encodeInput(context, writer, comp);
        }
    }

    private static void encodeInputAsText(FacesContext context, ResponseWriter writer, SelectOneListboxComponent comp) throws IOException {
        String displayValueOnlyStyle = comp.getDisplayValueOnlyStyle();
        String displayValueOnlyStyleClass = comp.getDisplayValueOnlyStyleClass();
        Boolean localize = comp.getLocalize();
        Boolean displayIdAndLabel = comp.getDisplayIdAndLabel();
        String display = comp.getDisplay();
        display = display == null ? "" : display;
        String id = comp.getStringProperty("id", null);
        writer.startElement("div", (UIComponent)comp);
        String selectedOption = SelectOneListboxRenderer.getCurrentSelectedValue((UIComponent)comp);
        if (id != null) {
            writer.writeAttribute("id", (Object)id, "id");
        }
        if (displayValueOnlyStyle != null) {
            writer.writeAttribute("style", (Object)displayValueOnlyStyle, "style");
        }
        if (displayValueOnlyStyleClass != null) {
            writer.writeAttribute("class", (Object)displayValueOnlyStyleClass, "class");
        }
        if (selectedOption != null) {
            Map<String, SelectItem> options = comp.getOptions();
            SelectItem item = options.get(selectedOption);
            if (item == null) {
                log.warn((Object)("option not found: " + selectedOption));
            } else {
                String optionId = (String)item.getValue();
                String optionLabel = item.getLabel();
                if (localize.booleanValue()) {
                    optionLabel = SelectOneListboxRenderer.translate(context, optionLabel);
                }
                String displayValue = DirectoryHelper.getOptionValue(optionId, optionLabel, display, displayIdAndLabel, " ");
                writer.writeText((Object)displayValue, null);
            }
        }
        writer.endElement("div");
    }

    private static void encodeInput(FacesContext context, ResponseWriter writer, SelectOneListboxComponent comp) throws IOException {
        String cssStyleClass = comp.getStringProperty("cssStyleClass", null);
        String cssStyle = comp.getStringProperty("cssStyle", null);
        String id = comp.getClientId(context);
        Boolean displayIdAndLabel = comp.getDisplayIdAndLabel();
        String display = comp.getStringProperty("display", "");
        display = display == null ? "" : display;
        String size = comp.getSize();
        String onchange = comp.getOnchange();
        writer.startElement("select", (UIComponent)comp);
        writer.writeAttribute("name", (Object)id, "name");
        writer.writeAttribute("id", (Object)id, "id");
        if (size != null) {
            writer.writeAttribute("size", (Object)size, "size");
        }
        if (cssStyleClass != null) {
            writer.writeAttribute("class", (Object)cssStyleClass, "class");
        }
        if (cssStyle != null) {
            writer.writeAttribute("style", (Object)cssStyle, "style");
        }
        if (onchange != null) {
            writer.writeAttribute("onchange", (Object)onchange, "onchange");
        }
        Map<String, SelectItem> options = comp.getOptions();
        String value = SelectOneListboxRenderer.getCurrentSelectedValue((UIComponent)comp);
        if (options != null) {
            String optionLabel;
            String optionId;
            ArrayList<SelectItem> newOptions = new ArrayList<SelectItem>();
            for (SelectItem item : options.values()) {
                optionId = (String)item.getValue();
                optionLabel = item.getLabel();
                SelectItem newItem = new SelectItem((Object)optionId, optionLabel);
                newOptions.add(newItem);
            }
            if (!comp.getNotDisplayDefaultOption().booleanValue()) {
                SelectOneListboxRenderer.displayDefaultOption(context, writer);
            }
            for (SelectItem item : newOptions) {
                optionId = (String)item.getValue();
                optionLabel = item.getLabel();
                String displayValue = DirectoryHelper.getOptionValue(optionId, optionLabel, display, displayIdAndLabel, " ");
                writer.startElement("option", (UIComponent)comp);
                writer.writeAttribute("value", (Object)optionId, "value");
                if (optionId.equals(value)) {
                    writer.writeAttribute("selected", (Object)"true", "selected");
                }
                writer.writeText((Object)displayValue, null);
                writer.endElement("option");
            }
        }
        writer.endElement("select");
    }

    protected static String getCurrentSelectedValue(UIComponent component) {
        Object submittedValue;
        if (component instanceof EditableValueHolder && (submittedValue = ((EditableValueHolder)component).getSubmittedValue()) != null) {
            return (String)submittedValue;
        }
        if (component instanceof ValueHolder) {
            Object value = ((ValueHolder)component).getValue();
            return (String)value;
        }
        return null;
    }

    private static void displayDefaultOption(FacesContext context, ResponseWriter writer) throws IOException {
        String defaultLabel = SelectOneListboxRenderer.translate(context, "label.vocabulary.selectValue");
        writer.startElement("option", null);
        writer.writeAttribute("value", (Object)"", "value");
        writer.writeText((Object)defaultLabel, null);
        writer.endElement("option");
    }

    protected static String translate(FacesContext context, String label) {
        String bundleName = context.getApplication().getMessageBundle();
        Locale locale = context.getViewRoot().getLocale();
        label = I18NUtils.getMessageString((String)bundleName, (String)label, null, (Locale)locale);
        return label;
    }
}

