/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.model.impl;

import java.util.ArrayList;
import java.util.List;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModel;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelListener;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelRow;
import org.nuxeo.ecm.platform.ui.web.model.impl.SelectDataModelRowImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectDataModelImpl
extends DataModel
implements SelectDataModel {
    protected int rowIndex = -1;
    protected String name;
    protected List data;
    protected List selectedData;
    protected List<SelectDataModelRow> rows;
    protected List<SelectDataModelListener> selectListeners;

    protected SelectDataModelImpl() {
    }

    public SelectDataModelImpl(String name, List data, List selectedData) {
        this.name = name;
        this.data = data;
        this.selectedData = selectedData;
        this.generateSelectRows();
    }

    public int getRowCount() {
        if (this.rows == null) {
            return -1;
        }
        return this.rows.size();
    }

    public Object getRowData() {
        if (this.rows == null) {
            return null;
        }
        if (!this.isRowAvailable()) {
            throw new IllegalArgumentException("row is unavailable");
        }
        return this.rows.get(this.rowIndex);
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public Object getWrappedData() {
        return this.rows;
    }

    public boolean isRowAvailable() {
        if (this.rows == null) {
            return false;
        }
        return this.rowIndex >= 0 && this.rowIndex < this.rows.size();
    }

    public void setRowIndex(int newRowIndex) {
        if (newRowIndex < -1) {
            throw new IllegalArgumentException("illegal rowIndex " + newRowIndex);
        }
        int oldRowIndex = this.rowIndex;
        this.rowIndex = newRowIndex;
        if (this.rows != null && oldRowIndex != this.rowIndex) {
            DataModelListener[] listeners;
            Object data = this.isRowAvailable() ? this.getRowData() : null;
            DataModelEvent event = new DataModelEvent((DataModel)this, this.rowIndex, data);
            for (DataModelListener listener : listeners = this.getDataModelListeners()) {
                listener.rowSelected(event);
            }
        }
    }

    public void setWrappedData(Object data) {
        if (data == null) {
            return;
        }
        throw new UnsupportedOperationException(((Object)((Object)this)).getClass().getName() + " UnsupportedOperationException");
    }

    protected void generateSelectRows() {
        if (this.data != null) {
            this.rows = new ArrayList<SelectDataModelRow>();
            for (Object item : this.data) {
                this.rows.add(new SelectDataModelRowImpl(this, this.isSelected(item), item));
            }
        }
    }

    private boolean isSelected(Object item) {
        if (this.selectedData == null) {
            return false;
        }
        return this.selectedData.contains(item);
    }

    public String getName() {
        return this.name;
    }

    public void addSelectModelListener(SelectDataModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener");
        }
        if (this.selectListeners == null) {
            this.selectListeners = new ArrayList<SelectDataModelListener>();
        }
        this.selectListeners.add(listener);
    }

    public void removeSelectModelListener(SelectDataModelListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener");
        }
        if (this.selectListeners != null) {
            this.selectListeners.remove(listener);
        }
    }

    public SelectDataModelListener[] getSelectModelListeners() {
        if (this.selectListeners == null) {
            return new SelectDataModelListener[0];
        }
        return this.selectListeners.toArray(new SelectDataModelListener[this.selectListeners.size()]);
    }

    public List<SelectDataModelRow> getRows() {
        return this.rows;
    }

    public void setRows(List<SelectDataModelRow> rows) {
        this.rows = rows;
    }
}

