/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.model.impl;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.ui.web.model.SelectDataModelRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SelectDocumentDataModelRowComparator
implements Comparator<SelectDataModelRow>,
Serializable {
    private static final long serialVersionUID = -5760751243552415990L;
    private static final Log log = LogFactory.getLog(SelectDocumentDataModelRowComparator.class);
    protected final String schemaName;
    protected final String fieldName;
    protected int ascending = -1;

    public SelectDocumentDataModelRowComparator(String schemaName, String fieldName, boolean ascending) {
        this.schemaName = schemaName;
        this.fieldName = fieldName;
        this.ascending = ascending ? 1 : -1;
    }

    @Override
    public int compare(SelectDataModelRow row1, SelectDataModelRow row2) {
        int result = 0;
        try {
            DocumentModel d1 = (DocumentModel)row1.getData();
            DocumentModel d2 = (DocumentModel)row2.getData();
            if (d1 == null) {
                result = d2 == null ? 0 : -1;
            } else if (d2 == null) {
                result = 1;
            } else {
                Object o1 = d1.getProperty(this.schemaName, this.fieldName);
                Object o2 = d2.getProperty(this.schemaName, this.fieldName);
                result = o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : (o1 instanceof Comparable ? ((Comparable)o1).compareTo(o2) : o1.toString().compareTo(o2.toString())));
            }
        }
        catch (Exception err) {
            log.error((Object)("Error when comparing rows " + err));
        }
        return result * this.ascending;
    }
}

