/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import java.io.Serializable;
import java.util.HashMap;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.Factory;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Manager;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.DocumentLocationImpl;
import org.nuxeo.ecm.platform.types.adapter.TypeInfo;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.WebActions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.ecm.platform.util.RepositoryLocation;

@Name(value="restHelper")
@Scope(value=ScopeType.EVENT)
public class RestHelper
implements Serializable {
    private static final long serialVersionUID = 1L;
    @In(create=true)
    transient NavigationContext navigationContext;
    @In(create=true)
    transient WebActions webActions;
    private DocumentView docView;
    private String baseURL = "";

    @Begin(id="#{conversationIdGenerator.currentOrNewMainConversationId}", join=true)
    public String initContextFromRestRequest(DocumentView docView) throws ClientException {
        String outcome = null;
        if (docView != null) {
            DocumentLocation docLoc = docView.getDocumentLocation();
            outcome = this.navigationContext.navigateTo(new RepositoryLocation(docLoc.getServerName()), docLoc.getDocRef());
        }
        return outcome;
    }

    public void setDocumentView(DocumentView docView) {
        this.docView = docView;
    }

    public DocumentView getNewDocumentView() {
        DocumentViewImpl docView = null;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        if (currentDocument != null) {
            DocumentLocationImpl docLoc = new DocumentLocationImpl(currentDocument);
            TypeInfo typeInfo = (TypeInfo)currentDocument.getAdapter(TypeInfo.class);
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("tabId", this.webActions.getCurrentTabId());
            params.put("subTabId", this.webActions.getCurrentSubTabId());
            if (currentDocument.isVersion()) {
                params.put("version", "true");
            }
            docView = new DocumentViewImpl((DocumentLocation)docLoc, typeInfo.getDefaultView(), params);
        }
        return docView;
    }

    public DocumentView getDocumentView() {
        return this.docView;
    }

    public static Manager getConversationManager() {
        if (Contexts.isEventContextActive()) {
            return Manager.instance();
        }
        return null;
    }

    protected static String addConversationRequestParameters(String url, Manager conversationManager, String conversationId) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(conversationManager.getConversationIdParameter(), conversationId);
        return conversationManager.encodeParameters(url, params);
    }

    public static String addCurrentConversationParameters(String url) {
        Manager conversationManager = RestHelper.getConversationManager();
        if (conversationManager == null) {
            return url;
        }
        return conversationManager.encodeConversationId(url);
    }

    public static String addMainConversationParameters(String url) {
        Manager conversationManager = RestHelper.getConversationManager();
        if (conversationManager == null) {
            return url;
        }
        String conversationId = conversationManager.isNestedConversation() ? conversationManager.getParentConversationId() : conversationManager.getCurrentConversationId();
        return RestHelper.addConversationRequestParameters(url, conversationManager, conversationId);
    }

    @Factory(value="baseURL", scope=ScopeType.CONVERSATION)
    public String getBaseURL() {
        if (this.baseURL.equals("")) {
            this.baseURL = BaseURL.getBaseURL();
        }
        return this.baseURL;
    }
}

