/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.rest;

import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.jboss.seam.util.DTDEntityResolver;
import org.xml.sax.EntityResolver;

public class StaticNavigationHandler {
    private static final Log log = LogFactory.getLog(StaticNavigationHandler.class);
    private Map<String, String> outcomeToViewId;
    private Map<String, String> viewIdToOutcome;

    public StaticNavigationHandler(ServletContext context) {
        InputStream stream = null;
        if (context != null) {
            stream = context.getResourceAsStream("/WEB-INF/faces-config.xml");
        }
        if (stream == null) {
            log.error((Object)"No faces-config.xml file found: cannot resolve view id from outcome");
        } else {
            log.debug((Object)"Reading faces-config.xml");
            this.parse(stream);
        }
    }

    public String getOutcomeFromViewId(String viewId) {
        if (viewId == null) {
            return null;
        }
        if (this.viewIdToOutcome != null && this.viewIdToOutcome.containsKey(viewId = viewId.replace(".faces", ".xhtml"))) {
            return this.viewIdToOutcome.get(viewId);
        }
        return viewId;
    }

    public String getViewIdFromOutcome(String outcome) {
        if (outcome == null) {
            return null;
        }
        if (this.outcomeToViewId != null && this.outcomeToViewId.containsKey(outcome)) {
            return this.outcomeToViewId.get(outcome).replace(".xhtml", ".faces");
        }
        return "/" + outcome + ".faces";
    }

    private void parse(InputStream stream) {
        this.outcomeToViewId = new HashMap<String, String>();
        this.viewIdToOutcome = new HashMap<String, String>();
        Element root = StaticNavigationHandler.getDocumentRoot(stream);
        List elements = root.elements("navigation-rule");
        for (Element rule : elements) {
            List nav_cases = rule.elements("navigation-case");
            for (Element nav_case : nav_cases) {
                Element from_el = nav_case.element("from-outcome");
                Element to_el = nav_case.element("to-view-id");
                if (from_el == null || to_el == null) continue;
                String from = from_el.getTextTrim();
                String to = to_el.getTextTrim();
                this.outcomeToViewId.put(from, to);
                this.viewIdToOutcome.put(to, from);
            }
        }
    }

    private static Element getDocumentRoot(InputStream stream) {
        try {
            SAXReader saxReader = new SAXReader();
            saxReader.setEntityResolver((EntityResolver)new DTDEntityResolver());
            saxReader.setMergeAdjacentText(true);
            return saxReader.read(stream).getRootElement();
        }
        catch (DocumentException de) {
            throw new RuntimeException(de);
        }
    }
}

