/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.repository.Repository;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseNuxeoRestlet;
import org.nuxeo.runtime.api.Framework;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class BaseStatelessNuxeoRestlet
extends BaseNuxeoRestlet {
    protected CoreSession session;
    protected DocumentRef targetDocRef;
    protected DocumentModel targetDocument;

    protected Boolean initRepository(Response res, String repoId) {
        RepositoryManager rm;
        DOMDocumentFactory domfactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domfactory.createDocument();
        if (repoId == null || repoId.equals("*")) {
            BaseStatelessNuxeoRestlet.handleError(result, res, "you must specify a repository");
            return false;
        }
        try {
            rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
        }
        catch (Exception e1) {
            BaseStatelessNuxeoRestlet.handleError(result, res, e1);
            return false;
        }
        Repository repo = rm.getRepository(repoId);
        if (repo == null) {
            BaseStatelessNuxeoRestlet.handleError(res, "Unable to get " + repoId + " repository");
            return false;
        }
        try {
            this.session = repo.open();
        }
        catch (Exception e1) {
            BaseStatelessNuxeoRestlet.handleError(result, res, e1);
            return false;
        }
        if (this.session == null) {
            BaseStatelessNuxeoRestlet.handleError(result, res, "Unable to open " + repoId + " repository");
            return false;
        }
        return true;
    }

    protected Boolean initRepositoryAndTargetDocument(Response res, String repoId, String docId) {
        RepositoryManager rm;
        DOMDocumentFactory domfactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domfactory.createDocument();
        if (repoId == null || repoId.equals("*")) {
            BaseStatelessNuxeoRestlet.handleError(result, res, "you must specify a repository");
            return false;
        }
        if (docId == null || docId.equals("")) {
            BaseStatelessNuxeoRestlet.handleError(result, res, "you must specify a document");
            return false;
        }
        try {
            rm = (RepositoryManager)Framework.getService(RepositoryManager.class);
        }
        catch (Exception e1) {
            BaseStatelessNuxeoRestlet.handleError(result, res, e1);
            return false;
        }
        Repository repo = rm.getRepository(repoId);
        if (repo == null) {
            BaseStatelessNuxeoRestlet.handleError(res, "Unable to get " + repoId + " repository");
            return false;
        }
        try {
            this.session = repo.open();
        }
        catch (Exception e1) {
            BaseStatelessNuxeoRestlet.handleError(result, res, e1);
            return false;
        }
        if (this.session == null) {
            BaseStatelessNuxeoRestlet.handleError(result, res, "Unable to open " + repoId + " repository");
            return false;
        }
        this.targetDocRef = new IdRef(docId);
        try {
            this.targetDocument = this.session.getDocument(this.targetDocRef);
        }
        catch (ClientException e) {
            BaseStatelessNuxeoRestlet.handleError(result, res, "Unable to open " + repoId + " repository");
            return false;
        }
        return true;
    }

    protected void cleanUp() {
        if (this.session != null) {
            CoreInstance.getInstance().close(this.session);
            this.session = null;
            this.targetDocRef = null;
            this.targetDocument = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(Request req, Response res) {
        try {
            this.doHandleStatelessRequest(req, res);
        }
        finally {
            this.cleanUp();
        }
    }

    protected void doHandleStatelessRequest(Request req, Response res) {
    }
}

