/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.restAPI;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.dom4j.dom.DOMDocument;
import org.dom4j.dom.DOMDocumentFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.platform.ui.web.restAPI.BaseStatelessNuxeoRestlet;
import org.nuxeo.ecm.platform.ui.web.tag.fn.LiveEditConstants;
import org.restlet.data.Form;
import org.restlet.data.MediaType;
import org.restlet.data.Request;
import org.restlet.data.Response;

public class UpdateDocumentRestlet
extends BaseStatelessNuxeoRestlet
implements LiveEditConstants {
    private static final Log log = LogFactory.getLog(UpdateDocumentRestlet.class);

    protected void doHandleStatelessRequest(Request req, Response res) {
        String repoId = (String)req.getAttributes().get("repo");
        String docId = (String)req.getAttributes().get("docid");
        DOMDocumentFactory domfactory = new DOMDocumentFactory();
        DOMDocument result = (DOMDocument)domfactory.createDocument();
        Boolean initOk = super.initRepositoryAndTargetDocument(res, repoId, docId);
        if (!initOk.booleanValue()) {
            return;
        }
        try {
            Form queryParameters = req.getResourceRef().getQueryAsForm();
            for (String paramName : queryParameters.getNames()) {
                if ("docType".equals(paramName)) continue;
                this.targetDocument.setPropertyValue(paramName, (Serializable)((Object)UpdateDocumentRestlet.getQueryParamValue(req, paramName, null)));
            }
            this.session.saveDocument(this.targetDocument);
            this.session.save();
            Element docElement = result.addElement(documentTag);
            docElement.addElement(docRefTag).setText("Document " + docId + " has been updated");
            res.setEntity(result.asXML(), MediaType.TEXT_XML);
        }
        catch (ClientException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            UpdateDocumentRestlet.handleError(res, (Exception)((Object)e));
        }
    }
}

