/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.tag.fn;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.utils.i18n.I18NUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Functions {
    private static UserManager userManager;
    private static final String FULLNAMES_MAP_KEY;
    static final Map<String, String> mapOfDateLength;

    private Functions() {
    }

    public static Object test(Boolean test, Object onSuccess, Object onFailure) {
        return test != false ? onSuccess : onFailure;
    }

    public static String join(String[] list, String separator) {
        return StringUtils.join((Object[])list, (String)separator);
    }

    public static String joinCollection(Collection<Object> collection, String separator) {
        if (collection == null) {
            return null;
        }
        return StringUtils.join(collection.iterator(), (String)separator);
    }

    public static String joinCollectionWithFinalDelimiter(Collection<Object> collection, String separator, String finalSeparator) {
        return Functions.joinArrayWithFinalDelimiter(collection.toArray(), separator, finalSeparator);
    }

    public static String joinArrayWithFinalDelimiter(Object[] collection, String separator, String finalSeparator) {
        if (collection == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        int i = 0;
        for (Object object : collection) {
            result.append(object);
            if (++i == collection.length - 1) {
                separator = finalSeparator;
            }
            if (i == collection.length) continue;
            result.append(separator);
        }
        return result.toString();
    }

    public static String formatDateUsingBasicFormatter(Date date) {
        return Functions.formatDate(date, Functions.basicDateFormater());
    }

    public static String formatDate(Date date, String format) {
        return new SimpleDateFormat(format).format(date);
    }

    public static String concat(String s1, String s2) {
        return s1 + s2;
    }

    public static String indentString(Integer level, String text) {
        StringBuilder label = new StringBuilder("");
        for (int i = 0; i < level; ++i) {
            label.append(text);
        }
        return label.toString();
    }

    public static boolean userIsMemberOf(String groupName) {
        FacesContext context = FacesContext.getCurrentInstance();
        NuxeoPrincipal principal = (NuxeoPrincipal)context.getExternalContext().getUserPrincipal();
        return principal.isMemberOf(groupName);
    }

    private static UserManager getUserManager() throws ClientException {
        if (userManager == null) {
            try {
                userManager = (UserManager)Framework.getService(UserManager.class);
            }
            catch (Exception e) {
                throw new ClientException((Throwable)e);
            }
        }
        return userManager;
    }

    public static String userFullName(String username) {
        String fullName;
        Map session;
        HashMap<String, String> fullNames;
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        if (username == null || username.length() == 0) {
            username = externalContext.getUserPrincipal().getName();
        }
        if ((fullNames = (HashMap<String, String>)(session = externalContext.getSessionMap()).get(FULLNAMES_MAP_KEY)) != null && fullNames.containsKey(username)) {
            return (String)fullNames.get(username);
        }
        try {
            NuxeoPrincipal principal = Functions.getUserManager().getPrincipal(username);
            fullName = principal != null ? Functions.principalFullName(principal) : username;
        }
        catch (ClientException e) {
            fullName = username;
        }
        if (fullNames == null) {
            fullNames = new HashMap<String, String>();
            session.put(FULLNAMES_MAP_KEY, fullNames);
        }
        fullNames.put(username, fullName);
        return fullName;
    }

    public static String principalFullName(NuxeoPrincipal principal) {
        String first = principal.getFirstName();
        String last = principal.getLastName();
        return Functions.userDisplayName(principal.getName(), first, last);
    }

    public static String userDisplayName(String id, String first, String last) {
        if (first == null || first.length() == 0) {
            if (last == null || last.length() == 0) {
                return id;
            }
            return last;
        }
        if (last == null || last.length() == 0) {
            return first;
        }
        return first + ' ' + last;
    }

    public static String dateFormater(String formatLength) {
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        DateFormat aDateFormat = DateFormat.getDateInstance(Integer.parseInt(mapOfDateLength.get(formatLength.toLowerCase())), locale);
        SimpleDateFormat format = (SimpleDateFormat)aDateFormat;
        return format.toPattern();
    }

    public static String basicDateFormater() {
        return Functions.dateFormater("short");
    }

    public static String dateAndTimeFormater(String formatLength) {
        FacesContext context = FacesContext.getCurrentInstance();
        Locale locale = context.getViewRoot().getLocale();
        DateFormat aDateFormat = DateFormat.getDateTimeInstance(Integer.parseInt(mapOfDateLength.get(formatLength.toLowerCase())), Integer.parseInt(mapOfDateLength.get(formatLength.toLowerCase())), locale);
        SimpleDateFormat format = (SimpleDateFormat)aDateFormat;
        return format.toPattern();
    }

    public static String basicDateAndTimeFormater() {
        return Functions.dateAndTimeFormater("short");
    }

    public static String printFileSize(String size) {
        return Functions.printFormatedFileSize(size, "SI", true);
    }

    public static String printFormatedFileSize(String sizeS, String format, Boolean isShort) {
        String msg;
        int ex;
        Integer size = sizeS == null || "".equals(sizeS) ? 0 : Integer.parseInt(sizeS);
        BytePrefix prefix = Enum.valueOf(BytePrefix.class, format);
        int base = prefix.getBase();
        String[] suffix = isShort != false ? prefix.getShortSuffixes() : prefix.getLongSuffixes();
        for (ex = 0; size > base - 1 || ex > suffix.length; ++ex) {
            size = size / base;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        if (context != null) {
            Locale locale;
            String bundleName = context.getApplication().getMessageBundle();
            msg = I18NUtils.getMessageString((String)bundleName, (String)"label.bytes.suffix", null, (Locale)(locale = context.getViewRoot().getLocale()));
            if ("label.bytes.suffix".equals(msg)) {
                msg = "B";
            }
        } else {
            msg = "B";
        }
        return "" + size + " " + suffix[ex] + msg;
    }

    public static Integer integerDivision(Integer x, Integer y) {
        return x / y;
    }

    static {
        FULLNAMES_MAP_KEY = Functions.class.getName() + ".FULLNAMES_MAP";
        mapOfDateLength = new HashMap<String, String>(){
            private static final long serialVersionUID = 8465772256977862352L;
            {
                this.put("short", String.valueOf(3));
                this.put("medium", String.valueOf(2));
                this.put("long", String.valueOf(1));
                this.put("full", String.valueOf(0));
            }
        };
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BytePrefix {
        SI(1000, new String[]{"", "k", "M", "G", "T", "P", "E", "Z", "Y"}, new String[]{"", "kilo", "mega", "giga", "tera", "exa", "zetta", "yotta"}),
        IEC(1024, new String[]{"", "Ki", "Mi", "Gi", "Ti", "Pi", "Ei", "Zi", "Yi"}, new String[]{"", "kibi", "mebi", "tebi", "pebi", "exbi", "zebi", "yobi"}),
        JEDEC(1024, new String[]{"", "K", "M", "G"}, new String[]{"", "kilo", "mega", "giga"});

        private final int base;
        private final String[] shortSuffixes;
        private final String[] longSuffixes;

        private BytePrefix(int base, String[] shortSuffixes, String[] longSuffixes) {
            this.base = base;
            this.shortSuffixes = shortSuffixes;
            this.longSuffixes = longSuffixes;
        }

        public int getBase() {
            return this.base;
        }

        public String[] getShortSuffixes() {
            return this.shortSuffixes;
        }

        public String[] getLongSuffixes() {
            return this.longSuffixes;
        }
    }
}

