/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.util;

import com.noelios.restlet.ext.servlet.ServletCall;
import com.noelios.restlet.http.HttpCall;
import com.noelios.restlet.http.HttpRequest;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUpload;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletRequestContext;
import org.jboss.seam.web.MultipartRequest;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.impl.blob.StreamingBlob;
import org.restlet.data.Request;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUploadHelper {
    public static List<Blob> parseRequest(Request request) throws Exception {
        HttpRequest httpRequest;
        HttpCall httpCall;
        if (request instanceof HttpRequest && (httpCall = (httpRequest = (HttpRequest)request).getHttpCall()) instanceof ServletCall) {
            HttpServletRequest httpServletRequest = ((ServletCall)httpCall).getRequest();
            return FileUploadHelper.parseRequest(httpServletRequest);
        }
        return null;
    }

    public static List<Blob> parseRequest(HttpServletRequest request) throws Exception {
        ArrayList<Blob> blobs = new ArrayList<Blob>();
        if (request instanceof MultipartRequest) {
            MultipartRequest seamMPRequest = (MultipartRequest)request;
            Enumeration names = seamMPRequest.getParameterNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                InputStream in = seamMPRequest.getFileInputStream(name);
                if (in == null) continue;
                StreamingBlob blob = StreamingBlob.createFromStream((InputStream)in);
                blob.setFilename(seamMPRequest.getFileName(name));
                blobs.add((Blob)blob);
            }
        } else {
            FileUpload fu = new FileUpload((FileItemFactory)new DiskFileItemFactory());
            String fileNameCharset = request.getHeader("FileNameCharset");
            if (fileNameCharset != null) {
                fu.setHeaderEncoding(fileNameCharset);
            }
            ServletRequestContext requestContext = new ServletRequestContext(request);
            List fileItems = fu.parseRequest((RequestContext)requestContext);
            for (FileItem item : fileItems) {
                Blob blob = StreamingBlob.createFromStream((InputStream)item.getInputStream()).persist();
                blob.setFilename(item.getName());
                blobs.add(blob);
            }
        }
        return blobs;
    }
}

