/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.core.listener;

import java.io.Serializable;
import java.security.Principal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyNotFoundException;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.filemanager.api.FileManager;
import org.nuxeo.runtime.api.Framework;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractUnicityChecker {
    private static final Log log = LogFactory.getLog(AbstractUnicityChecker.class);
    protected FileManager fileManager;
    protected static Boolean unicityCheckEnabled = null;
    protected static final String DUPLICATED_FILE = "duplicatedFile";

    protected void doUnicityCheck(DocumentModel doc2Check, CoreSession session, Event event) {
        List xpathFields = null;
        try {
            xpathFields = this.getFileManagerService().getFields();
        }
        catch (ClientException e) {
            log.error((Object)"Error while getting xpaths config from FileManager", (Throwable)e);
            return;
        }
        if (xpathFields == null || xpathFields.size() == 0) {
            unicityCheckEnabled = false;
            log.info((Object)"Unicity check has been automatically disabled");
            return;
        }
        Blob blob = null;
        for (String field : xpathFields) {
            blob = null;
            try {
                blob = (Blob)doc2Check.getPropertyValue(field);
            }
            catch (PropertyNotFoundException pnfe) {
                continue;
            }
            catch (ClientException e) {
                log.error((Object)"Error while getting property", (Throwable)e);
                continue;
            }
            if (blob == null) {
                log.debug((Object)"No blob retrieved");
                continue;
            }
            String digest = blob.getDigest();
            if (digest == null) {
                log.debug((Object)"Blob has no digest, can not check for unicity");
                continue;
            }
            List existingDocuments = null;
            try {
                existingDocuments = this.fileManager.findExistingDocumentWithFile(session, doc2Check.getPathAsString(), digest, session.getPrincipal());
            }
            catch (Exception e) {
                log.error((Object)"Error in FileManager unicity check execution", (Throwable)e);
                continue;
            }
            if (existingDocuments.isEmpty()) continue;
            Iterator existingDocumentsIterator = existingDocuments.iterator();
            while (existingDocumentsIterator.hasNext()) {
                if (((DocumentLocation)existingDocumentsIterator.next()).getDocRef() != doc2Check.getRef()) continue;
                existingDocumentsIterator.remove();
            }
            log.debug((Object)("Existing Documents[" + existingDocuments.size() + "]"));
            this.onDuplicatedDoc(session, session.getPrincipal(), doc2Check, existingDocuments, event);
        }
    }

    protected abstract void onDuplicatedDoc(CoreSession var1, Principal var2, DocumentModel var3, List<DocumentLocation> var4, Event var5);

    protected void raiseDuplicatedFileEvent(CoreSession session, Principal principal, DocumentModel newDoc, List<DocumentLocation> existingDocs) {
        DocumentEventContext ctx = new DocumentEventContext(session, principal, newDoc);
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("category", "clientCodeNotificationCategory");
        props.put("duplicatedDocLocation", (Serializable)((Object)existingDocs));
        Event event = ctx.newEvent(DUPLICATED_FILE);
        try {
            EventProducer producer = (EventProducer)Framework.getService(EventProducer.class);
            producer.fireEvent(event);
        }
        catch (Exception e) {
            log.error((Object)"Error while sending duplication message", (Throwable)e);
        }
    }

    protected boolean isUnicityCheckEnabled() {
        if (unicityCheckEnabled == null) {
            try {
                unicityCheckEnabled = this.getFileManagerService().isUnicityEnabled();
            }
            catch (ClientException e) {
                log.error((Object)"Unable to get FileManagerService", (Throwable)e);
                unicityCheckEnabled = false;
            }
        }
        return unicityCheckEnabled;
    }

    private FileManager getFileManagerService() throws ClientException {
        if (this.fileManager == null) {
            this.fileManager = (FileManager)Framework.getRuntime().getService(FileManager.class);
        }
        if (this.fileManager == null) {
            log.error((Object)"Unable to get FileManager runtime service");
            throw new ClientException("Unable to get FileManager runtime service");
        }
        return this.fileManager;
    }
}

