/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.core.listener;

import java.security.Principal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.filemanager.core.listener.AbstractUnicityChecker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousUnicityCheckListener
extends AbstractUnicityChecker
implements EventListener {
    private static final Log log = LogFactory.getLog(SynchronousUnicityCheckListener.class);

    public void handleEvent(Event event) throws ClientException {
        EventContext ctx;
        if (!this.isUnicityCheckEnabled()) {
            return;
        }
        ArrayList<String> uuids = new ArrayList<String>();
        if (("documentCreated".equals(event.getName()) || "documentModified".equals(event.getName())) && (ctx = event.getContext()) instanceof DocumentEventContext) {
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel doc2Check = docCtx.getSourceDocument();
            if (doc2Check.isProxy()) {
                // empty if block
            }
            if (!uuids.contains(doc2Check.getId())) {
                uuids.add(doc2Check.getId());
                this.doUnicityCheck(doc2Check, docCtx.getCoreSession(), event);
            }
        }
    }

    @Override
    protected void onDuplicatedDoc(CoreSession session, Principal principal, DocumentModel newDoc, List<DocumentLocation> existingDocs, Event event) {
        log.info((Object)"Duplicated file detected");
        this.raiseDuplicatedFileEvent(session, principal, newDoc, existingDocs);
    }
}

