/*
 * Decompiled with CFR 0.152.
 */
package com.anwrt.ooserver.daemon;

import com.anwrt.ooserver.daemon.AdminInstanceProvider;
import com.anwrt.ooserver.daemon.Daemon;
import com.anwrt.ooserver.daemon.Logger;
import com.sun.star.bridge.BridgeExistsException;
import com.sun.star.bridge.XInstanceProvider;
import com.sun.star.connection.AlreadyAcceptingException;
import com.sun.star.connection.ConnectionSetupException;
import com.sun.star.connection.XAcceptor;
import com.sun.star.connection.XConnection;
import com.sun.star.lang.IllegalArgumentException;
import com.sun.star.uno.UnoRuntime;
import java.util.Timer;

public class AdminAcceptorThread
extends Thread {
    private Daemon _daemon;
    private String _acceptString;
    private XAcceptor _acceptor;
    private Timer _shutdownThread = null;
    public static final String ADMIN_LOGGER_TAG = "#ADMIN# ";
    private static final int MAXIMUM_NUMBER_OF_ATTEMPTS = 50;

    public AdminAcceptorThread(Daemon daemon, Timer shutdownThread, String acceptString) {
        this._daemon = daemon;
        this._acceptString = acceptString;
        this._shutdownThread = shutdownThread;
        try {
            Object acceptorObj = daemon.getInitialContext().getServiceManager().createInstanceWithContext("com.sun.star.connection.Acceptor", daemon.getInitialContext());
            this._acceptor = (XAcceptor)UnoRuntime.queryInterface(XAcceptor.class, (Object)acceptorObj);
        }
        catch (Exception ex) {
            Logger.error("#ADMIN# Error getting acceptor");
            Logger.debug(ex);
        }
    }

    public void run() {
        Logger.info("#ADMIN# started");
        int numberOfAttempts = 0;
        while (numberOfAttempts < 50) {
            try {
                Thread.sleep(10L);
                ++numberOfAttempts;
                XConnection connexion = this._acceptor.accept(this._acceptString);
                if (connexion == null) break;
                Logger.debug("#ADMIN# Accepted admin connection from " + Daemon.extractContactInfo(connexion.getDescription()));
                this._daemon.getBridgeFactory().createBridge("", "urp", connexion, (XInstanceProvider)new AdminInstanceProvider(this._daemon, this._shutdownThread));
            }
            catch (AlreadyAcceptingException ex) {
                Logger.error("#ADMIN# Already accepting connection");
                Logger.debug((Exception)((Object)ex));
            }
            catch (ConnectionSetupException ex) {
                if (this._daemon.isShutdowned()) break;
                Logger.error(ADMIN_LOGGER_TAG + (Object)((Object)ex));
                Logger.debug((Exception)((Object)ex));
            }
            catch (BridgeExistsException ex) {
                Logger.error("#ADMIN# Bridge already exists");
                Logger.debug((Exception)((Object)ex));
            }
            catch (IllegalArgumentException ex) {
                Logger.error(ADMIN_LOGGER_TAG + (Object)((Object)ex));
                Logger.debug((Exception)((Object)ex));
            }
            catch (InterruptedException ex) {
                Logger.error(ADMIN_LOGGER_TAG + ex);
                Logger.debug(ex);
            }
        }
        if (numberOfAttempts == 50) {
            Logger.warning("#ADMIN# Could not connect!!!");
        }
        Logger.info("#ADMIN# terminating");
    }

    public void cancel() {
        this._acceptor.stopAccepting();
    }
}

