/*
 * Decompiled with CFR 0.152.
 */
package com.anwrt.ooserver.daemon;

import com.anwrt.ooserver.daemon.Config;
import com.anwrt.ooserver.daemon.ConfigHandler;
import com.anwrt.ooserver.daemon.Daemon;
import com.anwrt.ooserver.daemon.IncorrectLoggerLevelException;
import com.anwrt.ooserver.daemon.Log4JLogger;
import com.anwrt.ooserver.daemon.Logger;
import com.sun.star.beans.NamedValue;
import com.sun.star.bridge.XUnoUrlResolver;
import com.sun.star.comp.helper.Bootstrap;
import com.sun.star.container.XNameAccess;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.util.HashMap;

public final class CommandLine {
    public static final String ERROR_TAG = "error : ";
    private static Config _config = null;
    private static final String OPTION_PREFIX = "-";
    private static final String SPECIAL_OPTION_PREFIX = "--";
    private static final int _minArgs = 2;
    private static final String _optConfig = "config";
    private static final int _optConfigArgPos = 1;
    private static final int _optConfigShift = 2;
    private static final String _optAdmin = "admin";
    private static final int _optAdminArgPos = 1;
    private static final int _optAdminShift = 2;
    private static final String _optLogger = "logger";
    private static final int _optLoggerArgPos = 1;
    private static final int _optLoggerShift = 2;
    private static final String _optVersion = "version";
    private static final String _optHelp = "help";
    public static final String cmdStatus = "status";
    public static final String cmdStop = "stop";

    private CommandLine() {
    }

    private static String getDaemonStartupMessage(boolean isAdmin) {
        String line = "kkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkkk\n\n";
        String admin = "";
        if (isAdmin) {
            admin = " # ADMIN MODE #";
        }
        String msg = "\n" + line + "\t\t\tOPEN OFFICE DAEMON v1.0 beta" + admin + "\n" + "\n" + line;
        return msg;
    }

    private static void setLogLevel(String logLevel) {
        if (logLevel != null) {
            try {
                Logger.setLevel(logLevel);
            }
            catch (IncorrectLoggerLevelException ex) {
                System.err.println(ERROR_TAG + ex);
                System.out.println("  LEVELS : ");
                System.out.println(Logger.levelInformation("  ") + "\n");
            }
        }
    }

    private static boolean isAdminCommandValid(String command) {
        if (command.equals(cmdStatus)) {
            return true;
        }
        return command.equals(cmdStop);
    }

    private static String getCommandUrl(String command) {
        return "uno:" + CommandLine._config.adminAcceptor + ";urp" + ";daemon." + command;
    }

    private static void printStatus(XNameAccess status) throws Exception {
        System.out.println("STATUS");
        System.out.println("Instances in daemon (free/total) : " + status.getByName("available") + "/" + status.getByName("poolsize"));
        Object[] workers = (Object[])status.getByName("workers");
        System.out.println("Worker\tId\tin use\tusages\tduration\tuser-directory");
        for (int i = 0; i < workers.length; ++i) {
            HashMap worker = CommandLine.namedValueArrayToHashMap((NamedValue[])workers[i]);
            String out = "";
            String inuse = " ";
            String duration = "        \t";
            Long usageTime = (Long)worker.get("usage-time");
            if (usageTime > 0L) {
                inuse = "x";
                duration = Math.round((double)usageTime.longValue() * 0.001) + "s    \t";
            }
            System.out.println("Worker\t" + worker.get("index") + "\t" + inuse + "\t" + worker.get("usage") + "\t" + duration + worker.get("user-dir"));
        }
    }

    private static HashMap namedValueArrayToHashMap(NamedValue[] array) {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        for (int i = 0; i < array.length; ++i) {
            ret.put(array[i].Name, array[i].Value);
        }
        return ret;
    }

    private static void executeCommand(String command) throws Exception {
        if (!CommandLine.isAdminCommandValid(command)) {
            throw new Exception("invalid command " + command);
        }
        XComponentContext initialContext = Bootstrap.createInitialComponentContext(null);
        XMultiComponentFactory manager = initialContext.getServiceManager();
        Object unoResolverObj = manager.createInstanceWithContext("com.sun.star.bridge.UnoUrlResolver", initialContext);
        XUnoUrlResolver unoUrlResolver = (XUnoUrlResolver)UnoRuntime.queryInterface(XUnoUrlResolver.class, (Object)unoResolverObj);
        String url = CommandLine.getCommandUrl(command);
        try {
            if (command.equals(cmdStatus)) {
                Object statusObj = unoUrlResolver.resolve(url);
                if (statusObj == null) {
                    throw new Exception("cannot resolve Status");
                }
                XNameAccess status = (XNameAccess)UnoRuntime.queryInterface(XNameAccess.class, (Object)statusObj);
                CommandLine.printStatus(status);
            } else if (command.equals(cmdStop)) {
                unoUrlResolver.resolve(url);
            }
        }
        catch (Exception ex) {
            Logger.debug("URL : " + url);
            throw ex;
        }
    }

    private static void startAdminMode(String configPath, String adminCommand, String logLevel) {
        if (!CommandLine.isAdminCommandValid(adminCommand)) {
            Logger.error("error : invalid admin command : " + adminCommand);
        }
        try {
            ConfigHandler configHandler = new ConfigHandler();
            _config = configHandler.readConfiguration(configPath);
        }
        catch (Exception ex) {
            Logger.fatalError("Cannot read configuration", ex);
        }
        if (logLevel != null) {
            CommandLine.setLogLevel(logLevel);
        }
        try {
            CommandLine.executeCommand(adminCommand);
        }
        catch (Exception ex) {
            Logger.error("cannot execute command : " + adminCommand);
            Logger.debug(ex);
        }
    }

    private static void startNormalMode(String configPath, String logLevel) {
        Daemon daemon = new Daemon(configPath);
        CommandLine.setLogLevel(logLevel);
        daemon.run();
    }

    private static void printAdminCommands() {
        System.out.println(" ADMIN_COMMAND : \n   stop   : stops the current daemon. \n   status : get information about the daemon. \n");
    }

    private static void printVersion() {
        System.out.println("\n\nOpen Office Server Daemon " + Daemon.getVersionString());
        System.out.println("Copyright (C) 2007 Anyware Technologies");
        System.out.println("License LGPLv3+ : GNU LGPL version 3 or later <http://gnu.org/licenses/lgpl.html>");
        System.out.println("This is free software : you are free to change and redistribute it.");
        System.out.println("There is NO WARRANTY, to the extent permitted by law.\n");
    }

    private static void printHelpInformations() {
        System.out.println("\ncommand : Daemon -config <CONFIGURATION_FILE_PATH> [-admin ADMIN_COMMAND] [-logger <LOG_LEVEL>] \n");
        System.out.println("          Daemon --version");
        System.out.println("          Daemon --help");
        System.out.println("\n");
        System.out.println(" CONFIGURATION_FILE_PATH :\n   An xml configuration file required. \n   An example could be found in <DAEMON_DIR>/config/ \n");
        CommandLine.printAdminCommands();
        System.out.println(" LOG_LEVEL : \n   Specify a new log level \n   (higher priority than the log level in config file). \n");
        System.out.println(Logger.levelInformation("   "));
    }

    public static void start(String[] args) {
        boolean isAdmin = false;
        String configPath = null;
        String logLevel = null;
        int argPos = 0;
        String adminCommand = null;
        Logger.newInstance(new Log4JLogger());
        try {
            if (args.length < 2) {
                try {
                    if (args.length != 1) {
                        throw new Exception();
                    }
                    if (args[0].equals("--version")) {
                        CommandLine.printVersion();
                        return;
                    }
                    if (args[0].equals("--help")) {
                        CommandLine.printHelpInformations();
                        return;
                    }
                    throw new Exception();
                }
                catch (Exception ex) {
                    throw new Exception("wrong argument number");
                }
            }
            if (!args[argPos].equals("-config")) {
                throw new Exception("-config argument required");
            }
            configPath = args[argPos + 1];
            if (args.length >= (argPos += 2) + 1) {
                if (args[argPos].equals("-admin")) {
                    isAdmin = true;
                    if (args.length < argPos + 2) {
                        throw new Exception("ADMIN_COMMAND not specified after optin -admin");
                    }
                    adminCommand = args[argPos + 1];
                    if (args.length >= (argPos += 2) + 1 && args[argPos].equals("-logger")) {
                        if (args.length < argPos + 2) {
                            throw new Exception("LOG_LEVEL not specified after option -logger");
                        }
                        logLevel = args[argPos + 1];
                    }
                } else if (args[argPos].equals("-logger")) {
                    if (args.length < argPos + 2) {
                        throw new Exception("LOG_LEVEL not specified after option -logger");
                    }
                    logLevel = args[argPos + 1];
                }
            }
        }
        catch (Exception ex) {
            Logger.error(ex.getMessage());
            CommandLine.printHelpInformations();
        }
        System.out.println("Configuration file path : " + configPath);
        System.out.println(CommandLine.getDaemonStartupMessage(isAdmin));
        if (isAdmin) {
            CommandLine.startAdminMode(configPath, adminCommand, logLevel);
        } else {
            CommandLine.startNormalMode(configPath, logLevel);
        }
    }
}

