/*
 * Decompiled with CFR 0.152.
 */
package com.anwrt.ooserver.daemon;

import com.anwrt.ooserver.daemon.Config;
import com.anwrt.ooserver.daemon.IncorrectLoggerLevelException;
import com.anwrt.ooserver.daemon.Logger;
import com.anwrt.ooserver.daemon.OSAbstractLayer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class ConfigHandler
extends DefaultHandler
implements ContentHandler {
    private Config _config;
    private SAXParser _parser;

    public ConfigHandler() throws Exception {
        Logger.debug("parser starting ...");
        SAXParserFactory factory = SAXParserFactory.newInstance();
        this._parser = factory.newSAXParser();
        Logger.debug("parser OK");
    }

    public void startDocument() {
        this._config = new Config();
    }

    public void endDocument() {
    }

    public Config readConfiguration(String filePath) throws FileNotFoundException, SAXException, IOException {
        Logger.info("config : reading configuration file ... : " + filePath);
        File in = new File(filePath);
        if (!in.canRead()) {
            throw new FileNotFoundException("config : cannot get configuration file : " + filePath);
        }
        this._parser.parse(in, (DefaultHandler)this);
        Logger.info("config : configuration file OK");
        return this._config;
    }

    public void startElement(String uri, String localName, String qName, Attributes attlist) {
        if (qName.equals("acceptor")) {
            this._config.acceptor = attlist.getValue(0);
        } else if (qName.equals("admin-acceptor")) {
            this._config.adminAcceptor = attlist.getValue(0);
        } else if (qName.equals("open-office-install-path")) {
            String path = attlist.getValue("path");
            this._config.officeProgramDirectoryPath = OSAbstractLayer.concatPaths(path, "program");
        } else if (qName.equals("user-installation")) {
            this._config.userInstallation.add(attlist.getValue("url"));
        } else if (qName.equals("tolerated-startuptime-per-instance")) {
            int timeInSeconds = Integer.parseInt(attlist.getValue("value"));
            this._config.toleratedStartupTimePerInstance = this.convertSecondsToMillis(timeInSeconds);
        } else if (qName.equals("usage-count-per-instance")) {
            this._config.maxUsageCountPerInstance = Integer.parseInt(attlist.getValue("max"));
            this._config.randomUsageCountPerInstance = Integer.parseInt(attlist.getValue("random"));
        } else if (qName.equals("logger")) {
            try {
                Logger.setLevel(attlist.getValue("level"));
            }
            catch (IncorrectLoggerLevelException ex) {
                Logger.error(ex.getMessage());
            }
        }
    }

    public void endElement(String uri, String localName, String qName) {
    }

    public void warning(SAXParseException ex) {
        Logger.warning("config : " + ex.getMessage());
        Logger.debug(ex);
    }

    public void error(SAXParseException ex) {
        Logger.error("config : " + ex.getMessage());
        Logger.debug(ex);
    }

    public void skippedEntity(String name) throws SAXException {
        Logger.warning("config : skipped entity : " + name);
    }

    private int convertSecondsToMillis(int seconds) {
        return seconds * 1000;
    }
}

