/*
 * Decompiled with CFR 0.152.
 */
package com.anwrt.ooserver.daemon;

import com.anwrt.ooserver.daemon.Config;
import com.anwrt.ooserver.daemon.Logger;
import com.anwrt.ooserver.daemon.OfficeProcess;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;

public class ResponsivenessChecker
extends Thread {
    private OfficeProcess _process;
    private boolean _responsive;
    private Config _config;

    private synchronized boolean getResponsive() {
        return this._responsive;
    }

    public ResponsivenessChecker(Config config, OfficeProcess process) {
        this._process = process;
        this._responsive = false;
        this._config = config;
    }

    public boolean isResponsive() {
        try {
            this.join(this._config.sleepingDelay);
        }
        catch (InterruptedException ex) {
            Logger.debug(ex);
        }
        return this.getResponsive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            ResponsivenessChecker responsivenessChecker = this;
            synchronized (responsivenessChecker) {
                XComponentContext context = this._process.getContext();
                XMultiComponentFactory manager = context.getServiceManager();
                Object desktopObj = manager.createInstanceWithContext("com.sun.star.frame.Desktop", context);
                XDesktop desktop = (XDesktop)UnoRuntime.queryInterface(XDesktop.class, (Object)desktopObj);
                desktop.getCurrentComponent();
                this._responsive = true;
            }
        }
        catch (Exception ex) {
            Logger.error("responsiveness-check for " + this._process + " failed: " + ex);
            Logger.debug(ex);
            this._responsive = false;
        }
    }
}

