/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.ARQ;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.ARQInternalErrorException;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpBGP;
import com.hp.hpl.jena.sparql.algebra.op.OpDistinct;
import com.hp.hpl.jena.sparql.algebra.op.OpFilter;
import com.hp.hpl.jena.sparql.algebra.op.OpGraph;
import com.hp.hpl.jena.sparql.algebra.op.OpGroupAgg;
import com.hp.hpl.jena.sparql.algebra.op.OpJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpLeftJoin;
import com.hp.hpl.jena.sparql.algebra.op.OpList;
import com.hp.hpl.jena.sparql.algebra.op.OpNull;
import com.hp.hpl.jena.sparql.algebra.op.OpOrder;
import com.hp.hpl.jena.sparql.algebra.op.OpProject;
import com.hp.hpl.jena.sparql.algebra.op.OpReduced;
import com.hp.hpl.jena.sparql.algebra.op.OpService;
import com.hp.hpl.jena.sparql.algebra.op.OpSlice;
import com.hp.hpl.jena.sparql.algebra.op.OpTable;
import com.hp.hpl.jena.sparql.algebra.op.OpUnion;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.VarExprList;
import com.hp.hpl.jena.sparql.expr.Expr;
import com.hp.hpl.jena.sparql.expr.ExprList;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementFilter;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.syntax.ElementOptional;
import com.hp.hpl.jena.sparql.syntax.ElementService;
import com.hp.hpl.jena.sparql.syntax.ElementTriplesBlock;
import com.hp.hpl.jena.sparql.syntax.ElementUnion;
import com.hp.hpl.jena.sparql.util.ALog;
import com.hp.hpl.jena.sparql.util.Context;
import com.hp.hpl.jena.sparql.util.Utils;
import java.util.Iterator;
import java.util.ListIterator;

public class AlgebraGenerator {
    boolean fixedFilterPosition = false;
    private Context context;

    public AlgebraGenerator(Context context) {
        if (context == null) {
            context = ARQ.getContext().copy();
        }
        this.context = context;
    }

    public AlgebraGenerator() {
        this(null);
    }

    public Op compile(Query query) {
        Op pattern = this.compile(query.getQueryPattern());
        Op op = this.compileModifiers(query, pattern);
        return op;
    }

    public Op compile(Element elt) {
        if (elt instanceof ElementUnion) {
            return this.compile((ElementUnion)elt);
        }
        if (elt instanceof ElementGroup) {
            return this.compile((ElementGroup)elt);
        }
        if (elt instanceof ElementNamedGraph) {
            return this.compile((ElementNamedGraph)elt);
        }
        if (elt instanceof ElementService) {
            return this.compile((ElementService)elt);
        }
        if (elt instanceof ElementTriplesBlock) {
            return this.compile(((ElementTriplesBlock)elt).getTriples());
        }
        if (elt == null) {
            return new OpNull();
        }
        this.broken("compile(Element)/Not a structural element: " + Utils.className(elt));
        return null;
    }

    protected Op compile(ElementUnion el) {
        if (el.getElements().size() == 1) {
            Element subElt = (Element)el.getElements().get(0);
            ElementGroup elg = (ElementGroup)subElt;
            return this.compile(elg);
        }
        Op current = null;
        ListIterator iter = el.getElements().listIterator();
        while (iter.hasNext()) {
            Element subElt = (Element)iter.next();
            ElementGroup elg = (ElementGroup)subElt;
            Op op = this.compile(elg);
            if (current == null) {
                current = op;
                continue;
            }
            current = new OpUnion(current, op);
        }
        return current;
    }

    protected Op compile(ElementGroup groupElt) {
        if (this.fixedFilterPosition) {
            return this.compileFixed(groupElt);
        }
        ExprList filters = new ExprList();
        Op current = OpTable.unit();
        BasicPattern currentPattern = null;
        ListIterator iter = groupElt.getElements().listIterator();
        while (iter.hasNext()) {
            Op op;
            Element elt = (Element)iter.next();
            if (elt instanceof ElementTriplesBlock) {
                ElementTriplesBlock etb = (ElementTriplesBlock)elt;
                if (currentPattern == null) {
                    currentPattern = new BasicPattern();
                }
                currentPattern.addAll(etb.getTriples());
                continue;
            }
            if (elt instanceof ElementFilter) {
                ElementFilter f = (ElementFilter)elt;
                filters.add(f.getExpr());
                continue;
            }
            if (currentPattern != null) {
                op = this.compile(currentPattern);
                current = this.join(current, op);
            }
            currentPattern = null;
            if (elt instanceof ElementOptional) {
                ElementOptional eltOpt = (ElementOptional)elt;
                current = this.compile(eltOpt, current);
                continue;
            }
            if (elt instanceof ElementGroup || elt instanceof ElementNamedGraph || elt instanceof ElementService || elt instanceof ElementUnion) {
                op = this.compile(elt);
                current = this.join(current, op);
                continue;
            }
            this.broken("compile/group: not a fixed element, optional or filter: " + Utils.className(elt));
        }
        if (currentPattern != null) {
            Op op = this.compile(currentPattern);
            current = this.join(current, op);
        }
        if (!filters.isEmpty()) {
            if (current == null) {
                current = OpTable.unit();
            }
            current = OpFilter.filter(filters, current);
        }
        return current;
    }

    protected Op compile(ElementOptional eltOpt, Op current) {
        Element subElt = eltOpt.getOptionalElement();
        Op op = this.compile(subElt);
        ExprList exprs = null;
        if (op instanceof OpFilter) {
            OpFilter f = (OpFilter)op;
            Op sub = f.getSubOp();
            if (sub instanceof OpFilter) {
                this.broken("compile/Optional/nested filters - unfinished");
            }
            exprs = f.getExprs();
            op = sub;
        }
        current = OpLeftJoin.create(current, op, exprs);
        return current;
    }

    protected Op compile(BasicPattern pattern) {
        return new OpBGP(pattern);
    }

    protected Op compile(ElementNamedGraph eltGraph) {
        Node graphNode = eltGraph.getGraphNameNode();
        Op sub = this.compile(eltGraph.getElement());
        return new OpGraph(graphNode, sub);
    }

    protected Op compile(ElementService eltService) {
        Node serviceNode = eltService.getServiceNode();
        Op sub = this.compile(eltService.getElement());
        return new OpService(serviceNode, sub);
    }

    private Op compileFixed(ElementGroup groupElt) {
        Op current = OpTable.unit();
        ListIterator iter = groupElt.getElements().listIterator();
        while (iter.hasNext()) {
            Element elt = (Element)iter.next();
            current = this.compileDirect(elt, current);
        }
        return current;
    }

    private Op compileDirect(Element elt, Op current) {
        if (elt instanceof ElementTriplesBlock) {
            ElementTriplesBlock etb = (ElementTriplesBlock)elt;
            Op op = this.compile(etb.getTriples());
            return this.join(current, op);
        }
        if (elt instanceof ElementFilter) {
            ElementFilter f = (ElementFilter)elt;
            return OpFilter.filter(new ExprList(f.getExpr()), current);
        }
        if (elt instanceof ElementOptional) {
            ElementOptional eltOpt = (ElementOptional)elt;
            return this.compile(eltOpt, current);
        }
        if (elt instanceof ElementGroup || elt instanceof ElementNamedGraph || elt instanceof ElementUnion) {
            Op op = this.compile(elt);
            return this.join(current, op);
        }
        this.broken("compileDirect/Element not recognized: " + Utils.className(elt));
        return null;
    }

    public Op compileModifiers(Query query, Op pattern) {
        VarExprList projectVars;
        Op op = pattern;
        if (this.context.isTrue(ARQ.generateToList)) {
            op = new OpList(op);
        }
        if (query.hasGroupBy()) {
            op = new OpGroupAgg(op, query.getGroupBy(), query.getAggregators());
        } else if (query.getAggregators().size() > 0) {
            op = new OpGroupAgg(op, query.getGroupBy(), query.getAggregators());
        }
        if (query.hasHaving()) {
            Iterator iter = query.getHavingExprs().iterator();
            while (iter.hasNext()) {
                Expr expr = (Expr)iter.next();
                op = OpFilter.filter(expr, op);
            }
        }
        if (query.getOrderBy() != null) {
            op = new OpOrder(op, query.getOrderBy());
        }
        if (!(projectVars = query.getProject()).isEmpty() && !query.isQueryResultStar()) {
            if (projectVars.size() == 0 && query.isSelectType()) {
                ALog.warn(this, "No project variables");
            }
            if (projectVars.size() > 0) {
                op = new OpProject(op, query.getProject());
            }
        }
        if (query.isDistinct()) {
            op = new OpDistinct(op);
        }
        if (query.isReduced()) {
            op = new OpReduced(op);
        }
        if (query.hasLimit() || query.hasOffset()) {
            op = new OpSlice(op, query.getOffset(), query.getLimit());
        }
        return op;
    }

    protected Op join(Op current, Op newOp) {
        return OpJoin.create(current, newOp);
    }

    private void broken(String msg) {
        System.err.println("AlgebraCompiler: " + msg);
        throw new ARQInternalErrorException(msg);
    }
}

