/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.sparql.algebra;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.query.Query;
import com.hp.hpl.jena.sparql.algebra.AlgebraGenerator;
import com.hp.hpl.jena.sparql.algebra.Op;
import com.hp.hpl.jena.sparql.algebra.op.OpDatasetNames;
import com.hp.hpl.jena.sparql.algebra.op.OpQuadPattern;
import com.hp.hpl.jena.sparql.core.BasicPattern;
import com.hp.hpl.jena.sparql.core.Quad;
import com.hp.hpl.jena.sparql.syntax.Element;
import com.hp.hpl.jena.sparql.syntax.ElementGroup;
import com.hp.hpl.jena.sparql.syntax.ElementNamedGraph;
import com.hp.hpl.jena.sparql.util.Context;

public class AlgebraGeneratorQuad
extends AlgebraGenerator {
    private Node currentGraph = Quad.defaultGraphNode;

    public static Op compileQuery(Query query) {
        return new AlgebraGeneratorQuad().compile(query);
    }

    public static Op compilePattern(Element elt) {
        return new AlgebraGeneratorQuad().compile(elt);
    }

    public AlgebraGeneratorQuad(Context context) {
        super(context);
    }

    public AlgebraGeneratorQuad() {
    }

    protected Op compile(BasicPattern pattern) {
        return new OpQuadPattern(this.currentGraph, pattern);
    }

    protected Op compile(ElementNamedGraph eltGraph) {
        Node graphNode = eltGraph.getGraphNameNode();
        Node g = this.currentGraph;
        this.currentGraph = graphNode;
        if (eltGraph.getElement() instanceof ElementGroup && ((ElementGroup)eltGraph.getElement()).isEmpty()) {
            return new OpDatasetNames(graphNode);
        }
        Op sub = this.compile(eltGraph.getElement());
        this.currentGraph = g;
        return sub;
    }
}

