/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.usermanager;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XNodeMap;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.platform.usermanager.VirtualUserDescriptor;

@XObject(value="userManager")
public class UserManagerDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNode(value="@class")
    protected Class<?> userManagerClass;
    @XNode(value="defaultGroup")
    protected String defaultGroup;
    @XNodeList(value="defaultAdministratorId", type=ArrayList.class, componentType=String.class)
    protected List<String> defaultAdministratorIds;
    @XNodeList(value="administratorsGroup", type=ArrayList.class, componentType=String.class)
    protected List<String> administratorsGroups;
    @XNode(value="disableDefaultAdministratorsGroup")
    Boolean disableDefaultAdministratorsGroup;
    @XNode(value="userSortField")
    protected String userSortField;
    @XNode(value="groupSortField")
    protected String groupSortField;
    @XNode(value="users/directory")
    protected String userDirectoryName;
    @XNode(value="users/emailField")
    protected String userEmailField;
    @XNode(value="users/listingMode")
    protected String userListingMode;
    protected boolean userSearchFieldsPresent = false;
    @XNode(value="users/searchFields@append")
    protected boolean userSearchFieldsAppend;
    Map<String, UserManager.MatchType> userSearchFields = new LinkedHashMap<String, UserManager.MatchType>();
    protected Pattern userPasswordPattern;
    @XNode(value="users/anonymousUser")
    protected VirtualUserDescriptor anonymousUser;
    @XNodeMap(value="users/virtualUser", key="@id", type=HashMap.class, componentType=VirtualUserDescriptor.class)
    protected Map<String, VirtualUserDescriptor> virtualUsers;
    @XNode(value="groups/directory")
    protected String groupDirectoryName;
    @XNode(value="groups/membersField")
    protected String groupMembersField;
    @XNode(value="groups/subGroupsField")
    protected String groupSubGroupsField;
    @XNode(value="groups/parentGroupsField")
    protected String groupParentGroupsField;
    @XNode(value="groups/listingMode")
    protected String groupListingMode;

    @XNode(value="userListingMode")
    protected void setUserListingMode(String userListingMode) {
        this.userListingMode = userListingMode;
    }

    @XNode(value="users/searchFields")
    protected void setUserSearchFieldsPresent(String text) {
        this.userSearchFieldsPresent = true;
    }

    @XNodeList(value="users/searchFields/exactMatchSearchField", componentType=String.class, type=String[].class)
    protected void setExactMatchUserSearchFields(String[] fields) {
        for (String field : fields) {
            this.userSearchFields.put(field, UserManager.MatchType.EXACT);
        }
    }

    @XNodeList(value="users/searchFields/substringMatchSearchField", componentType=String.class, type=String[].class)
    protected void setSubstringMatchUserSearchFields(String[] fields) {
        for (String field : fields) {
            this.userSearchFields.put(field, UserManager.MatchType.SUBSTRING);
        }
    }

    @Deprecated
    @XNodeList(value="users/searchFields/searchField", componentType=String.class, type=String[].class)
    protected void setUserSearchFields(String[] fields) {
        this.setSubstringMatchUserSearchFields(fields);
    }

    @XNode(value="userPasswordPattern")
    protected void setUserPasswordPattern(String pattern) {
        this.userPasswordPattern = Pattern.compile(pattern);
    }

    public void merge(UserManagerDescriptor other) {
        if (other.userManagerClass != null) {
            this.userManagerClass = other.userManagerClass;
        }
        if (other.userListingMode != null) {
            this.userListingMode = other.userListingMode;
        }
        if (other.groupListingMode != null) {
            this.groupListingMode = other.groupListingMode;
        }
        if (other.defaultGroup != null) {
            this.defaultGroup = other.defaultGroup;
        }
        if (other.defaultAdministratorIds != null) {
            if (this.defaultAdministratorIds == null) {
                this.defaultAdministratorIds = new ArrayList<String>();
            }
            this.defaultAdministratorIds.addAll(other.defaultAdministratorIds);
        }
        if (other.administratorsGroups != null) {
            if (this.administratorsGroups == null) {
                this.administratorsGroups = new ArrayList<String>();
            }
            this.administratorsGroups.addAll(other.administratorsGroups);
        }
        if (other.disableDefaultAdministratorsGroup != null) {
            this.disableDefaultAdministratorsGroup = other.disableDefaultAdministratorsGroup;
        }
        if (other.userSearchFieldsPresent) {
            if (other.userSearchFieldsAppend) {
                this.userSearchFields.putAll(other.userSearchFields);
            } else {
                this.userSearchFields = other.userSearchFields;
            }
        }
        if (other.userSortField != null) {
            this.userSortField = other.userSortField;
        }
        if (other.groupSortField != null) {
            this.groupSortField = other.groupSortField;
        }
        if (other.userDirectoryName != null) {
            this.userDirectoryName = other.userDirectoryName;
        }
        if (other.userEmailField != null) {
            this.userEmailField = other.userEmailField;
        }
        if (other.userSearchFieldsPresent) {
            if (other.userSearchFieldsAppend) {
                this.userSearchFields.putAll(other.userSearchFields);
            } else {
                this.userSearchFields = other.userSearchFields;
            }
        }
        if (other.userPasswordPattern != null) {
            this.userPasswordPattern = other.userPasswordPattern;
        }
        if (other.groupDirectoryName != null) {
            this.groupDirectoryName = other.groupDirectoryName;
        }
        if (other.groupMembersField != null) {
            this.groupMembersField = other.groupMembersField;
        }
        if (other.groupSubGroupsField != null) {
            this.groupSubGroupsField = other.groupSubGroupsField;
        }
        if (other.groupParentGroupsField != null) {
            this.groupParentGroupsField = other.groupParentGroupsField;
        }
        if (other.anonymousUser != null) {
            this.anonymousUser = other.anonymousUser.remove ? null : other.anonymousUser;
        }
        if (other.virtualUsers != null) {
            if (this.virtualUsers == null) {
                this.virtualUsers = other.virtualUsers;
            } else {
                for (VirtualUserDescriptor otherVirtualUser : other.virtualUsers.values()) {
                    if (this.virtualUsers.containsKey(otherVirtualUser.id) && otherVirtualUser.remove) {
                        this.virtualUsers.remove(otherVirtualUser.id);
                        continue;
                    }
                    this.virtualUsers.put(otherVirtualUser.id, otherVirtualUser);
                }
            }
        }
    }
}

