/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.filemanager.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;

public final class FileManagerUtils {
    private FileManagerUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        byte[] bytes = new byte[(int)length];
        try {
            int offset;
            int numRead = 0;
            for (offset = 0; offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
            }
            if (offset < bytes.length) {
                throw new IOException("Could not completely read InputStream");
            }
        }
        finally {
            is.close();
        }
        return bytes;
    }

    public static String fetchFileName(File file) throws MalformedURLException {
        URL pathUrl = file.toURI().toURL();
        String[] pathArray = pathUrl.getFile().split("/");
        return pathArray[pathArray.length - 1];
    }

    public static String fetchFileName(String fullName) {
        int lastUnixSeparator;
        String ret = fullName;
        int lastWinSeparator = fullName.lastIndexOf(92);
        int lastSeparator = Math.max(lastWinSeparator, lastUnixSeparator = fullName.lastIndexOf(47));
        if (lastSeparator != -1) {
            ret = fullName.substring(lastSeparator + 1, fullName.length());
        }
        return ret;
    }

    public static String fetchTitle(String filename) {
        if (filename.startsWith(".")) {
            return filename;
        }
        int dot = filename.lastIndexOf(46);
        String title = filename;
        if (dot != -1) {
            title = filename.substring(0, filename.lastIndexOf(46));
        }
        return title;
    }

    public static DocumentModel getExistingDocByFileName(CoreSession documentManager, String path, String filename) throws ClientException {
        DocumentModel existing = null;
        PathRef pathRef = new PathRef(path);
        DocumentModelList docList = documentManager.getChildren((DocumentRef)pathRef);
        for (DocumentModel doc : docList) {
            String existFileName;
            String currentLifeCycleState = doc.getCurrentLifeCycleState();
            if ("deleted".equals(currentLifeCycleState) || (existFileName = (String)doc.getProperty("file", "filename")) == null || !existFileName.equals(filename)) continue;
            existing = doc;
            break;
        }
        return existing;
    }

    public static DocumentModel getExistingDocByTitle(CoreSession documentManager, String path, String title) throws ClientException {
        DocumentModel existing = null;
        PathRef pathRef = new PathRef(path);
        DocumentModelList docList = documentManager.getChildren((DocumentRef)pathRef);
        for (DocumentModel doc : docList) {
            String existTitle;
            String currentLifeCycleState = doc.getCurrentLifeCycleState();
            if ("deleted".equals(currentLifeCycleState) || (existTitle = (String)doc.getProperty("dublincore", "title")) == null || !existTitle.equals(title)) continue;
            existing = doc;
            break;
        }
        return existing;
    }
}

