/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.webengine.sites.listeners;

import java.io.Serializable;
import java.util.ArrayList;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.webengine.sites.utils.SitesRelationsWikiHelper;

public class SitesWikiListener
implements EventListener {
    private static final Log log = LogFactory.getLog(SitesWikiListener.class);
    private final String openBracket = "[";
    private final String closeBracket = "]";

    public void handleEvent(Event event) {
        String eventName = event.getName();
        if (!("documentModified".equals(eventName) || "documentCreated".equals(eventName) || "beforeDocumentModification".equals(eventName) || "aboutToCreate".equals(eventName))) {
            return;
        }
        if (!(event.getContext() instanceof DocumentEventContext)) {
            return;
        }
        DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
        DocumentModel webPage = docCtx.getSourceDocument();
        if (webPage == null || !"WebPage".equals(webPage.getType())) {
            return;
        }
        try {
            Boolean isRichText = Boolean.TRUE;
            isRichText = (Boolean)webPage.getPropertyValue("webp:isRichtext");
            if (isRichText.booleanValue()) {
                return;
            }
            ArrayList<String> relationLinks = new ArrayList<String>();
            if ("beforeDocumentModification".equals(event.getName()) || "aboutToCreate".equals(event.getName())) {
                String wikiContent = (String)((Object)webPage.getPropertyValue("webp:content"));
                String[] wikiLinks = this.getLinks(wikiContent);
                String basePath = (String)((Object)webPage.getContextData("basePath"));
                String targetObjectPath = (String)((Object)webPage.getContextData("targetObjectPath"));
                for (int i = 0; i < wikiLinks.length; ++i) {
                    boolean isNamedLink;
                    String[] splitWikiLinks = StringUtils.split((String)wikiLinks[i]);
                    String linkString = splitWikiLinks[0];
                    boolean bl = isNamedLink = splitWikiLinks.length > 1;
                    if (!linkString.startsWith("http://") && !linkString.startsWith(basePath)) {
                        String newLinkString;
                        if (linkString.startsWith(".")) {
                            newLinkString = basePath + linkString.replace(".", "/");
                        } else {
                            newLinkString = linkString.replace(".", "/");
                            newLinkString = targetObjectPath + "/" + newLinkString;
                        }
                        relationLinks.add(newLinkString);
                        if (!isNamedLink) {
                            newLinkString = newLinkString + " " + linkString;
                        }
                        wikiContent = wikiContent.replace(linkString, newLinkString);
                    }
                    if (!linkString.startsWith(basePath)) continue;
                    relationLinks.add(linkString);
                }
                webPage.setPropertyValue("webp:content", (Serializable)((Object)wikiContent));
            }
            SitesRelationsWikiHelper.updateRelations((DocumentModel)webPage, relationLinks);
        }
        catch (ClientException e) {
            log.error((Object)"SitesWikiListener error...", (Throwable)e);
        }
    }

    private String[] getLinks(String content) {
        int endPosition;
        int startPosition;
        if (content == null) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        int contentLength = content.length();
        if (contentLength == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        ArrayList<String> returnList = new ArrayList<String>();
        int currentPosition = 0;
        while (currentPosition < contentLength - 1 && (startPosition = content.indexOf("[", currentPosition)) >= 0 && (endPosition = content.indexOf("]", ++startPosition)) >= 0) {
            returnList.add(content.substring(startPosition, endPosition));
            currentPosition = endPosition + 1;
        }
        if (returnList.size() > 0) {
            return returnList.toArray(new String[returnList.size()]);
        }
        return ArrayUtils.EMPTY_STRING_ARRAY;
    }
}

