/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.web;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipException;
import java.util.zip.ZipOutputStream;
import javax.ejb.Remove;
import javax.faces.context.FacesContext;
import javax.faces.model.SelectItem;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.core.Events;
import org.nuxeo.common.utils.IdUtils;
import org.nuxeo.common.utils.ZipUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureBlobHolder;
import org.nuxeo.ecm.platform.picture.web.PictureBookManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;
import org.nuxeo.ecm.platform.ui.web.api.UserAction;
import org.nuxeo.ecm.webapp.base.InputController;
import org.nuxeo.ecm.webapp.documentsLists.DocumentsListsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="pictureBookManager")
@Scope(value=ScopeType.CONVERSATION)
public class PictureBookManagerBean
extends InputController
implements PictureBookManager,
Serializable {
    private static final long serialVersionUID = -1593206839472821743L;
    private static final Log log = LogFactory.getLog(PictureBookManagerBean.class);
    @In(create=true)
    CoreSession documentManager;
    Integer timeinterval;
    Integer maxsize;
    ArrayList<Map<String, Object>> views;
    String title;
    String viewtitle;
    String tag;
    String description;
    List<SelectItem> selectItems;
    String[] selectedViews = new String[]{"Original"};
    @In(create=true)
    private transient NavigationContext navigationContext;
    @In(create=true)
    protected transient DocumentsListsManager documentsListsManager;
    private static final int BUFFER = 2048;

    protected DocumentModel getCurrentDocument() {
        return this.navigationContext.getCurrentDocument();
    }

    @Override
    @Create
    public void initialize() throws Exception {
        log.debug((Object)"Initializing...");
        this.initViews();
    }

    private void initViews() {
        this.views = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", "Medium");
        map.put("maxsize", 550);
        map.put("tag", "medium");
        map.put("description", "MediumSize Picture");
        this.views.add(map);
        map = new HashMap();
        map.put("title", "Original");
        map.put("maxsize", null);
        map.put("tag", "original");
        map.put("description", "Original Picture");
        this.views.add(map);
        map = new HashMap();
        map.put("title", "Thumbnail");
        map.put("maxsize", 100);
        map.put("tag", "thumbnail");
        map.put("description", "ThumbnailSize Picture");
        this.views.add(map);
        map = new HashMap();
        map.put("title", "OriginalJpeg");
        map.put("maxsize", null);
        map.put("tag", "originalJpeg");
        map.put("description", "Original Picture in JPEG format");
        this.views.add(map);
    }

    @Override
    @Destroy
    @Remove
    public void destroy() {
        this.title = null;
        this.timeinterval = null;
        this.viewtitle = null;
        this.maxsize = null;
        this.tag = null;
        this.description = null;
        this.views = null;
        log.debug((Object)"Destroy");
    }

    @Override
    public String createPictureBook() throws Exception {
        DocumentModel doc = this.navigationContext.getChangeableDocument();
        String parentPath = this.getCurrentDocument() == null ? this.documentManager.getRootDocument().getPathAsString() : this.navigationContext.getCurrentDocument().getPathAsString();
        String title = (String)doc.getProperty("dublincore", "title");
        if (title == null) {
            title = "";
        }
        String name = IdUtils.generateId((String)title);
        doc.setPathInfo(parentPath, name);
        doc.setProperty("picturebook", "timeinterval", (Object)this.timeinterval);
        doc.setProperty("picturebook", "picturetemplates", this.views);
        Events.instance().raiseEvent("documentChildrenChanged", new Object[]{this.documentManager.getDocument((DocumentRef)new PathRef(parentPath))});
        doc = this.documentManager.createDocument(doc);
        this.documentManager.saveDocument(doc);
        this.documentManager.save();
        return this.navigationContext.getActionResult(doc, UserAction.AFTER_CREATE);
    }

    @Override
    public void addView() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("title", this.viewtitle);
        map.put("maxsize", this.maxsize);
        map.put("tag", this.tag);
        map.put("description", this.description);
        this.views.add(map);
    }

    @Override
    @Observer(value={"documentSelectionChanged"})
    @BypassInterceptors
    public void reset() throws ClientException {
        this.title = null;
        this.timeinterval = null;
        this.maxsize = null;
        this.viewtitle = null;
        this.tag = null;
        this.description = null;
        this.selectItems = null;
        this.selectedViews = new String[]{"Original"};
        this.initViews();
    }

    @Override
    public String downloadSelectedBook() throws ClientException, IOException {
        List list = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        return this.createZip(list);
    }

    @Override
    public String downloadAll() throws ClientException, IOException {
        DocumentModelList list = this.navigationContext.getCurrentDocumentChildren();
        return this.createZip((List<DocumentModel>)list);
    }

    private boolean isEmptyFolder(DocumentModel doc) throws ClientException {
        DocumentModelList docList = this.documentManager.getChildren(doc.getRef());
        for (DocumentModel docChild : docList) {
            BlobHolder bh = (BlobHolder)docChild.getAdapter(BlobHolder.class);
            if (docChild.isFolder()) {
                return this.isEmptyFolder(docChild);
            }
            if (bh == null) continue;
            return false;
        }
        return true;
    }

    private String formatFileName(String filename, String count) {
        StringBuilder sb = new StringBuilder();
        CharSequence name = filename.subSequence(0, filename.lastIndexOf("."));
        CharSequence extension = filename.subSequence(filename.lastIndexOf("."), filename.length());
        sb.append(name).append(count).append(extension);
        return sb.toString();
    }

    private void addBlobHolderToZip(String path, ZipOutputStream out, byte[] data, PictureBlobHolder bh) throws IOException, ClientException {
        List blobs = this.selectedViews != null ? bh.getBlobs(this.selectedViews) : bh.getBlobs();
        block2: for (Blob content : blobs) {
            String fileName = content.getFilename();
            if (content == null) continue;
            int tryCount = 0;
            while (true) {
                try {
                    if (tryCount == 0) {
                        ZipUtils._zip((String)(path + fileName), (InputStream)content.getStream(), (ZipOutputStream)out);
                        continue block2;
                    }
                    ZipUtils._zip((String)(path + this.formatFileName(fileName, "(" + tryCount + ")")), (InputStream)content.getStream(), (ZipOutputStream)out);
                    continue block2;
                }
                catch (ZipException e) {
                    ++tryCount;
                    continue;
                }
                break;
            }
        }
    }

    private void addFolderToZip(String path, ZipOutputStream out, DocumentModel doc, byte[] data) throws ClientException, IOException {
        String title = (String)doc.getProperty("dublincore", "title");
        DocumentModelList docList = this.documentManager.getChildren(doc.getRef());
        for (DocumentModel docChild : docList) {
            if (docChild.getCurrentLifeCycleState().equals("delete")) continue;
            BlobHolder bh = (BlobHolder)docChild.getAdapter(BlobHolder.class);
            if (docChild.isFolder() && !this.isEmptyFolder(docChild)) {
                this.addFolderToZip(path + title + "/", out, docChild, data);
                continue;
            }
            if (bh == null) continue;
            this.addBlobHolderToZip(path + title + "/", out, data, (PictureBlobHolder)bh);
        }
    }

    private String createZip(List<DocumentModel> documents) throws IOException, ClientException {
        FacesContext context = FacesContext.getCurrentInstance();
        HttpServletResponse response = (HttpServletResponse)context.getExternalContext().getResponse();
        BufferedOutputStream buff = new BufferedOutputStream((OutputStream)response.getOutputStream());
        ZipOutputStream out = new ZipOutputStream(buff);
        out.setMethod(8);
        out.setLevel(9);
        byte[] data = new byte[2048];
        for (DocumentModel doc : documents) {
            if (doc.getSessionId() == null) {
                doc = this.documentManager.getDocument(doc.getRef());
            }
            if (doc.getCurrentLifeCycleState().equals("delete")) continue;
            BlobHolder bh = (BlobHolder)doc.getAdapter(BlobHolder.class);
            if (doc.isFolder() && !this.isEmptyFolder(doc)) {
                this.addFolderToZip("", out, doc, data);
                continue;
            }
            if (bh == null) continue;
            this.addBlobHolderToZip("", out, data, (PictureBlobHolder)bh);
        }
        try {
            out.close();
        }
        catch (ZipException e) {
            this.setFacesMessage("label.clipboard.emptyDocuments");
            return null;
        }
        response.setHeader("Content-Disposition", "attachment; filename=\"clipboard.zip\";");
        response.setContentType("application/gzip");
        response.flushBuffer();
        context.responseComplete();
        return null;
    }

    private void initSelectItems() throws ClientException {
        DocumentModel doc = this.getCurrentDocument();
        List views = (List)doc.getProperty("picturebook", "picturetemplates");
        this.selectItems = new ArrayList<SelectItem>(views.size());
        for (Map map : views) {
            String label = (String)map.get("title");
            SelectItem selectItem = new SelectItem((Object)label, label);
            this.selectItems.add(selectItem);
        }
    }

    @Override
    public List<SelectItem> getSelectItems() throws ClientException {
        if (this.selectItems == null) {
            this.initSelectItems();
            return this.selectItems;
        }
        return this.selectItems;
    }

    @Override
    public void setSelectItems(List<SelectItem> selectItems) {
        this.selectItems = selectItems;
    }

    @Override
    public String[] getSelectedViews() {
        return this.selectedViews;
    }

    @Override
    public void setSelectedViews(String[] selectedViews) {
        this.selectedViews = selectedViews;
    }

    @Override
    @Deprecated
    public Integer getTimeinterval() {
        if (this.timeinterval == null) {
            this.timeinterval = 5;
        }
        return this.timeinterval;
    }

    @Override
    public void setTimeinterval(Integer timeinterval) {
        this.timeinterval = timeinterval;
    }

    @Override
    public Integer getMaxsize() {
        return this.maxsize;
    }

    @Override
    public void setMaxsize(Integer maxsize) {
        this.maxsize = maxsize;
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public void setTitle(String title) {
        this.title = title;
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public void setTag(String tag) {
        this.tag = tag;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String getViewtitle() {
        return this.viewtitle;
    }

    @Override
    public void setViewtitle(String viewtitle) {
        this.viewtitle = viewtitle;
    }

    @Override
    public ArrayList<Map<String, Object>> getViews() {
        return this.views;
    }

    @Override
    public void setViews(ArrayList<Map<String, Object>> views) {
        this.views = views;
    }
}

