/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.web;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.ejb.Remove;
import javax.faces.event.ActionEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.Destroy;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Observer;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.picture.web.PictureBookManagerBean;
import org.nuxeo.ecm.platform.picture.web.SlideShowManager;
import org.nuxeo.ecm.platform.ui.web.api.NavigationContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="slideShowManager")
@Scope(value=ScopeType.CONVERSATION)
public class SlideShowManagerBean
implements SlideShowManager,
Serializable {
    private static final long serialVersionUID = -3281363416111697725L;
    private static final Log log = LogFactory.getLog(PictureBookManagerBean.class);
    @In(create=true)
    protected transient NavigationContext navigationContext;
    protected List<DocumentModel> children;
    protected Integer childrenSize = null;
    protected DocumentModel child;
    protected Integer index;
    protected Boolean stopped;
    protected Boolean repeat;

    @Override
    @Create
    public void initialize() throws Exception {
        log.debug((Object)"Initializing...");
        this.index = 1;
        this.childrenSize = null;
        this.stopped = false;
        this.repeat = false;
    }

    @Override
    public void firstPic() {
        this.index = 1;
    }

    @Override
    public void lastPic() {
        this.index = this.getChildren().size();
    }

    @Override
    @Destroy
    @Remove
    public void destroy() {
        log.debug((Object)"Destroy");
        this.index = null;
        this.child = null;
        this.childrenSize = null;
        this.stopped = null;
        this.repeat = null;
    }

    @Override
    public Integer getIndex() {
        return this.index;
    }

    @Override
    public void decIndex() {
        Integer n = this.index;
        Integer n2 = this.index = Integer.valueOf(this.index - 1);
    }

    @Override
    public void incIndex() {
        Integer n = this.index;
        Integer n2 = this.index = Integer.valueOf(this.index + 1);
        if (this.index > this.getChildrenSize()) {
            this.index = this.repeat != false ? Integer.valueOf(1) : this.childrenSize;
        }
    }

    @Override
    public void setIndex(Integer idx) {
        this.index = idx;
    }

    @Override
    @Observer(value={"documentSelectionChanged", "documentChildrenChanged"})
    @BypassInterceptors
    public void resetIndex() throws ClientException {
        this.index = 1;
        this.child = null;
        this.children = null;
        this.childrenSize = null;
        this.stopped = false;
        this.repeat = false;
    }

    @Override
    public void inputValidation(ActionEvent arg0) {
        if (this.getChildrenSize() < this.index) {
            this.index = this.getChildrenSize();
        }
        if (this.index <= 0) {
            this.index = 1;
        }
    }

    @Override
    public Integer getChildrenSize() {
        if (this.childrenSize == null) {
            this.childrenSize = this.getChildren().size();
        }
        return this.childrenSize;
    }

    @Override
    public DocumentModel getChild() {
        if (this.index > this.getChildrenSize()) {
            this.index = this.childrenSize;
        }
        if (!this.getChildren().isEmpty()) {
            return this.getChildren().get(this.index - 1);
        }
        return null;
    }

    protected List<DocumentModel> getChildren() {
        try {
            if (this.children == null) {
                this.children = this.navigationContext.getCurrentDocumentChildren();
            }
        }
        catch (ClientException e) {
            log.error((Object)e, (Throwable)e);
            this.children = Collections.emptyList();
        }
        return this.children;
    }

    @Override
    public void setChild(DocumentModel child) {
        this.child = child;
    }

    public void togglePause() {
        this.stopped = true;
    }

    public void stop() {
        this.index = 1;
        this.stopped = true;
    }

    public void start() {
        this.stopped = false;
    }

    public Boolean getStopped() {
        return this.stopped;
    }

    public void toggleRepeat() {
        this.repeat = this.repeat == false;
    }

    public void setStopped(Boolean stopped) {
        this.stopped = stopped;
    }

    public Boolean getRepeat() {
        return this.repeat;
    }

    public void setRepeat(Boolean repeat) {
        this.repeat = repeat;
    }
}

