/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletException;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.Layout;
import org.nuxeo.ecm.platform.forms.layout.api.LayoutRow;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.facelets.WidgetTagHandler;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public class LayoutTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(LayoutTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute name;
    protected final TagAttribute mode;
    protected final TagAttribute value;

    public LayoutTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.name = this.getRequiredAttribute("name");
        this.mode = this.getRequiredAttribute("mode");
        this.value = this.getRequiredAttribute("value");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, FaceletException, ELException {
        WebLayoutManager layoutService;
        try {
            layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        String layoutName = this.name.getValue(ctx);
        String modeValue = this.mode.getValue(ctx);
        String valueName = this.value.getValue();
        if (ComponentTagUtils.isValueReference((String)valueName)) {
            valueName = valueName.substring(2, valueName.length() - 1);
        }
        VariableMapper orig = ctx.getVariableMapper();
        VariableMapperWrapper vm = new VariableMapperWrapper(orig);
        ctx.setVariableMapper((VariableMapper)vm);
        ValueExpression valueExpr = this.value.getValueExpression(ctx, Object.class);
        vm.setVariable(RenderVariables.globalVariables.value.name(), valueExpr);
        vm.setVariable(RenderVariables.globalVariables.document.name(), valueExpr);
        vm.setVariable(RenderVariables.globalVariables.layoutValue.name(), valueExpr);
        ExpressionFactory eFactory = ctx.getExpressionFactory();
        ValueExpression modeVe = eFactory.createValueExpression((Object)modeValue, String.class);
        vm.setVariable(RenderVariables.globalVariables.layoutMode.name(), modeVe);
        vm.setVariable(RenderVariables.globalVariables.mode.name(), modeVe);
        Layout layout = layoutService.getLayout(ctx, layoutName, modeValue, valueName);
        if (layout == null) {
            log.error((Object)String.format("Layout %s not found", layoutName));
            return;
        }
        ValueExpression layoutVe = eFactory.createValueExpression((Object)layout, Layout.class);
        vm.setVariable(RenderVariables.layoutVariables.layout.name(), layoutVe);
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, this.config);
        layout.setId(helper.generateLayoutId(layout.getName()));
        String template = layout.getTemplate();
        try {
            if (template != null) {
                ctx.includeFacelet(parent, template);
            } else {
                log.error((Object)("Missing template property for layout " + layoutName + " => applying basic template"));
                for (LayoutRow row : layout.getRows()) {
                    for (Widget widget : row.getWidgets()) {
                        WidgetTagHandler.applyWidgetHandler(ctx, parent, this.config, widget, this.value, false);
                    }
                }
            }
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }
}

