/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import com.sun.facelets.tag.TagHandler;
import java.io.IOException;
import java.io.Serializable;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;

public class SubWidgetTagHandler
extends TagHandler {
    private static final Log log = LogFactory.getLog(SubWidgetTagHandler.class);
    protected final TagConfig config;

    public SubWidgetTagHandler(TagConfig config) {
        super(config);
        this.config = config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        Widget widget = null;
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, this.config);
        String widgetVariableName = RenderVariables.widgetVariables.widget.name();
        TagAttribute widgetAttribute = helper.createAttribute(widgetVariableName, (Serializable)((Object)String.format("#{%s}", widgetVariableName)));
        if (widgetAttribute != null) {
            widget = (Widget)widgetAttribute.getObject(ctx, Widget.class);
        }
        if (widget == null) {
            log.error((Object)("Could not resolve widget " + widgetAttribute));
            return;
        }
        Widget[] subWidgets = widget.getSubWidgets();
        if (subWidgets == null || subWidgets.length == 0) {
            return;
        }
        VariableMapper orig = ctx.getVariableMapper();
        ctx.setVariableMapper((VariableMapper)new VariableMapperWrapper(orig));
        try {
            int subWidgetCounter = 0;
            for (Widget subWidget : subWidgets) {
                VariableMapper vm = ctx.getVariableMapper();
                ValueExpression subWidgetVe = ctx.getExpressionFactory().createValueExpression((Object)subWidget, Widget.class);
                vm.setVariable(RenderVariables.widgetVariables.widget.name(), subWidgetVe);
                vm.setVariable(String.format("%s_%s", RenderVariables.widgetVariables.widget.name(), subWidget.getLevel()), subWidgetVe);
                ValueExpression subWidgetIndexVe = ctx.getExpressionFactory().createValueExpression((Object)subWidgetCounter, Integer.class);
                vm.setVariable(RenderVariables.widgetVariables.widgetIndex.name(), subWidgetIndexVe);
                vm.setVariable(String.format("%s_%s", RenderVariables.widgetVariables.widgetIndex.name(), subWidget.getLevel()), subWidgetIndexVe);
                this.nextHandler.apply(ctx, parent);
                ++subWidgetCounter;
            }
        }
        finally {
            ctx.setVariableMapper(orig);
        }
    }
}

