/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.platform.forms.layout.api.FieldDefinition;
import org.nuxeo.runtime.api.Framework;

public class ValueExpressionHelper {
    private ValueExpressionHelper() {
    }

    public static String createExpressionString(String valueName, FieldDefinition field) {
        String dmResolverValue;
        String propertyName;
        String[] s;
        if (field == null || "".equals(field.getPropertyName())) {
            return String.format("#{%s}", valueName);
        }
        String schemaName = field.getSchemaName();
        String fieldName = field.getFieldName();
        if (schemaName == null && (s = (propertyName = field.getFieldName()).split(":")).length == 2) {
            String prefix = s[0];
            Schema schema = null;
            try {
                SchemaManager tm = (SchemaManager)Framework.getService(SchemaManager.class);
                schema = tm.getSchemaFromPrefix(prefix);
            }
            catch (Exception e) {
                // empty catch block
            }
            schemaName = schema == null ? prefix : schema.getName();
            fieldName = s[1];
        }
        String[] splittedFieldName = fieldName.split("/");
        StringBuffer newFieldName = new StringBuffer();
        boolean first = true;
        for (String item : splittedFieldName) {
            try {
                newFieldName.append(String.format("[%s]", Integer.parseInt(item)));
            }
            catch (NumberFormatException e) {
                if (!first) {
                    newFieldName.append(String.format(".%s", item));
                }
                newFieldName.append(item);
            }
            first = false;
        }
        if (schemaName == null) {
            dmResolverValue = String.format("#{%s.%s}", valueName, newFieldName);
        } else {
            String fieldValue = String.format("%s.%s", schemaName, newFieldName);
            dmResolverValue = String.format("#{%s.%s}", valueName, fieldValue);
        }
        return dmResolverValue;
    }
}

