/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.forms.layout.facelets;

import com.sun.facelets.FaceletContext;
import com.sun.facelets.FaceletHandler;
import com.sun.facelets.el.VariableMapperWrapper;
import com.sun.facelets.tag.MetaTagHandler;
import com.sun.facelets.tag.TagAttribute;
import com.sun.facelets.tag.TagConfig;
import java.io.IOException;
import javax.el.ELException;
import javax.el.ValueExpression;
import javax.el.VariableMapper;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.forms.layout.api.Widget;
import org.nuxeo.ecm.platform.forms.layout.facelets.FaceletHandlerHelper;
import org.nuxeo.ecm.platform.forms.layout.facelets.RenderVariables;
import org.nuxeo.ecm.platform.forms.layout.service.WebLayoutManager;
import org.nuxeo.ecm.platform.ui.web.util.ComponentTagUtils;
import org.nuxeo.runtime.api.Framework;

public class WidgetTagHandler
extends MetaTagHandler {
    private static final Log log = LogFactory.getLog(WidgetTagHandler.class);
    protected final TagConfig config;
    protected final TagAttribute widget;
    protected final TagAttribute mode;
    protected final TagAttribute value;

    public WidgetTagHandler(TagConfig config) {
        super(config);
        this.config = config;
        this.widget = this.getRequiredAttribute("widget");
        this.mode = this.getRequiredAttribute("mode");
        this.value = this.getRequiredAttribute("value");
    }

    public void apply(FaceletContext ctx, UIComponent parent) throws IOException, FacesException, ELException {
        Widget widgetInstance = (Widget)this.widget.getObject(ctx, Widget.class);
        if (widgetInstance != null) {
            String valueName = this.value.getValue();
            if (ComponentTagUtils.isValueReference((String)valueName)) {
                valueName = valueName.substring(2, valueName.length() - 1);
            }
            widgetInstance.setValueName(valueName);
            WidgetTagHandler.applyWidgetHandler(ctx, parent, this.config, widgetInstance, this.value, true);
        }
    }

    public static void generateWidgetIdsRecursive(FaceletHandlerHelper helper, Widget widget) {
        if (widget == null) {
            return;
        }
        widget.setId(helper.generateWidgetId(widget.getName()));
        Widget[] subWidgets = widget.getSubWidgets();
        if (subWidgets != null) {
            for (Widget subWidget : subWidgets) {
                WidgetTagHandler.generateWidgetIdsRecursive(helper, subWidget);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyWidgetHandler(FaceletContext ctx, UIComponent parent, TagConfig config, Widget widget, TagAttribute value, boolean fillVariables) throws IOException {
        WebLayoutManager layoutService;
        if (widget == null) {
            return;
        }
        try {
            layoutService = (WebLayoutManager)Framework.getService(WebLayoutManager.class);
        }
        catch (Exception e) {
            throw new FacesException((Throwable)e);
        }
        FaceletHandlerHelper helper = new FaceletHandlerHelper(ctx, config);
        WidgetTagHandler.generateWidgetIdsRecursive(helper, widget);
        FaceletHandler handler = layoutService.getFaceletHandler(ctx, config, widget);
        if (handler == null) {
            return;
        }
        if (fillVariables) {
            VariableMapper orig = ctx.getVariableMapper();
            VariableMapperWrapper vm = new VariableMapperWrapper(orig);
            ctx.setVariableMapper((VariableMapper)vm);
            try {
                ValueExpression valueExpr = value.getValueExpression(ctx, Object.class);
                vm.setVariable(RenderVariables.globalVariables.value.name(), valueExpr);
                vm.setVariable(String.format("%s_%s", RenderVariables.globalVariables.value.name(), widget.getLevel()), valueExpr);
                vm.setVariable(RenderVariables.globalVariables.document.name(), valueExpr);
                handler.apply(ctx, parent);
            }
            finally {
                ctx.setVariableMapper(orig);
            }
        } else {
            handler.apply(ctx, parent);
        }
    }
}

