/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.compose;

import com.hp.hpl.jena.JenaRuntime;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphStatisticsHandler;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.compose.Polyadic;
import com.hp.hpl.jena.graph.impl.SimpleEventManager;
import com.hp.hpl.jena.graph.query.QueryHandler;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NullIterator;
import java.util.Iterator;
import java.util.Set;

public class MultiUnion
extends Polyadic {
    private boolean optimising = JenaRuntime.getSystemProperty("jena.union.optimise", "yes").equals("yes");

    public MultiUnion() {
    }

    public MultiUnion(Graph[] graphs) {
        super(graphs);
    }

    public MultiUnion(Iterator graphs) {
        super(graphs);
    }

    private boolean optimiseOne() {
        return this.optimising && this.m_subGraphs.size() == 1;
    }

    public Reifier getReifier() {
        Graph base = this.getBaseGraph();
        return base == null ? super.getReifier() : base.getReifier();
    }

    protected GraphStatisticsHandler createStatisticsHandler() {
        return new MultiUnionStatisticsHandler(this);
    }

    public void performAdd(Triple t) {
        this.getRequiredBaseGraph().add(t);
    }

    public void performDelete(Triple t) {
        this.getRequiredBaseGraph().delete(t);
    }

    public boolean graphBaseContains(Triple t) {
        Iterator i = this.m_subGraphs.iterator();
        while (i.hasNext()) {
            if (!((Graph)i.next()).contains(t)) continue;
            return true;
        }
        return false;
    }

    public QueryHandler queryHandler() {
        return this.optimiseOne() ? this.singleGraphQueryHandler() : super.queryHandler();
    }

    private QueryHandler singleGraphQueryHandler() {
        return ((Graph)this.m_subGraphs.get(0)).queryHandler();
    }

    public ExtendedIterator graphBaseFind(TripleMatch t) {
        ExtendedIterator found = this.optimiseOne() ? this.singleGraphFind(t) : this.multiGraphFind(t);
        return SimpleEventManager.notifyingRemove(this, found);
    }

    private ExtendedIterator singleGraphFind(TripleMatch t) {
        return ((Graph)this.m_subGraphs.get(0)).find(t);
    }

    private ExtendedIterator multiGraphFind(TripleMatch t) {
        Set seen = CollectionFactory.createHashedSet();
        ExtendedIterator result = NullIterator.instance;
        Iterator graphs = this.m_subGraphs.iterator();
        while (graphs.hasNext()) {
            ExtendedIterator newTriples = MultiUnion.recording(MultiUnion.rejecting(((Graph)graphs.next()).find(t), seen), seen);
            result = result.andThen(newTriples);
        }
        return result;
    }

    public void addGraph(Graph graph) {
        if (!this.m_subGraphs.contains(graph)) {
            this.m_subGraphs.add(graph);
        }
    }

    public static class MultiUnionStatisticsHandler
    implements GraphStatisticsHandler {
        protected final MultiUnion mu;

        public MultiUnionStatisticsHandler(MultiUnion mu) {
            this.mu = mu;
        }

        public long getStatistic(Node S, Node P, Node O) {
            long result = 0L;
            for (int i = 0; i < this.mu.m_subGraphs.size(); ++i) {
                Graph g = (Graph)this.mu.m_subGraphs.get(i);
                GraphStatisticsHandler s = g.getStatisticsHandler();
                long n = s.getStatistic(S, P, O);
                if (n < 0L) {
                    return n;
                }
                result += n;
            }
            return result;
        }

        public MultiUnion getUnion() {
            return this.mu;
        }
    }
}

