/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.api;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.runtime.api.ServiceDescriptor;
import org.nuxeo.runtime.api.ServiceHost;
import org.nuxeo.runtime.api.ServiceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceGroup
implements Serializable {
    private static final Log log = LogFactory.getLog(ServiceGroup.class);
    private static final long serialVersionUID = -206692130381710767L;
    private final String name;
    private final ServiceGroup parent;
    private ServiceHost server;

    public ServiceGroup(String name) {
        if (name == null || name.equals("*") || name.length() == 0) {
            this.name = "*";
            this.parent = null;
        } else {
            this.name = name;
            int p = name.lastIndexOf(47);
            this.parent = p < 1 ? ServiceManager.getInstance().getRootGroup() : ServiceManager.getInstance().getOrCreateGroup(name.substring(0, p));
        }
    }

    public String getName() {
        return this.name;
    }

    public ServiceHost getServer() {
        if (this.server == null) {
            this.server = this.parent == null ? ServiceHost.LOCAL_SERVER : this.parent.getServer();
        }
        if (this.server.getServiceLocatorClass() == null) {
            log.warn((Object)"No ServiceLocator Returning a LOCAL_SERVER instead of a ServiceHost");
            return ServiceHost.LOCAL_SERVER;
        }
        return this.server;
    }

    public <T> T getService(Class<T> serviceClass) throws Exception {
        ServiceDescriptor sd = ServiceManager.getInstance().getServiceDescriptor(serviceClass);
        if (sd == null) {
            return null;
        }
        return (T)this.getServer().lookup(sd);
    }

    public <T> T getService(Class<T> serviceClass, String name) throws Exception {
        ServiceDescriptor sd = ServiceManager.getInstance().getServiceDescriptor(serviceClass.getName(), name);
        if (sd == null) {
            return null;
        }
        return (T)this.getServer().lookup(sd);
    }

    public Object lookup(ServiceDescriptor sd) throws Exception {
        return this.getServer().lookup(sd);
    }

    public void setServer(ServiceHost server) {
        if (server == null) {
            log.debug((Object)("service group " + this.getName() + " no longer has a server!"));
        } else if (server.getServiceLocatorClass() == null) {
            log.debug((Object)("service group " + this.getName() + " just had its ServiceHost removed!"));
        }
        this.server = server;
    }

    public void addService(ServiceDescriptor sd) {
    }

    public void removeService(ServiceDescriptor sd) {
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceGroup)) {
            return false;
        }
        ServiceGroup sg = (ServiceGroup)obj;
        return sg.name.equals(this.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }
}

