/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.osgi;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.Environment;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.runtime.AbstractRuntimeService;
import org.nuxeo.runtime.Version;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentName;
import org.nuxeo.runtime.model.RuntimeContext;
import org.nuxeo.runtime.model.impl.ComponentPersistence;
import org.nuxeo.runtime.model.impl.RegistrationInfoImpl;
import org.nuxeo.runtime.osgi.OSGiRuntimeContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OSGiRuntimeService
extends AbstractRuntimeService
implements FrameworkListener {
    public static final ComponentName FRAMEWORK_STARTED_COMP = new ComponentName("org.nuxeo.runtime.started");
    public static final String PROP_HOME_DIR = "org.nuxeo.runtime.home";
    public static final String PROP_INSTALL_DIR = "INSTALL_DIR";
    public static final String PROP_CONFIG_DIR = "CONFIG_DIR";
    public static final String PROP_HOST_ADAPTER = "HOST_ADAPTER";
    public static final String PROP_NUXEO_BIND_ADDRESS = "nuxeo.bind.address";
    public static final String NAME = "OSGi NXRuntime";
    public static final Version VERSION = Version.parseString("1.4.0");
    private static final Log log = LogFactory.getLog(OSGiRuntimeService.class);
    private static final Log componentDebugLog = LogFactory.getLog((String)"nuxeo.bundle.debug");
    private final BundleContext bundleContext;
    private final Map<String, RuntimeContext> contexts;
    final Map<String, Bundle> bundles;
    final ComponentPersistence persistence;

    public OSGiRuntimeService(BundleContext context) {
        this(new OSGiRuntimeContext(context.getBundle()), context);
    }

    public OSGiRuntimeService(OSGiRuntimeContext runtimeContext, BundleContext context) {
        super(runtimeContext);
        this.bundleContext = context;
        this.bundles = new Hashtable<String, Bundle>();
        this.contexts = new ConcurrentHashMap<String, RuntimeContext>();
        String bindAddress = context.getProperty(PROP_NUXEO_BIND_ADDRESS);
        if (bindAddress != null) {
            this.properties.put(PROP_NUXEO_BIND_ADDRESS, bindAddress);
        }
        String homeDir = this.getProperty(PROP_HOME_DIR);
        componentDebugLog.info((Object)("Home directory: " + homeDir));
        this.workingDir = homeDir != null ? new File(homeDir) : this.bundleContext.getDataFile("/");
        Environment env = Environment.getDefault();
        if (env == null) {
            Environment.setDefault((Environment)new Environment(this.workingDir));
        }
        this.workingDir.mkdirs();
        this.persistence = new ComponentPersistence(this);
        componentDebugLog.info((Object)("Working directory: " + this.workingDir));
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Version getVersion() {
        return VERSION;
    }

    public BundleContext getBundleContext() {
        return this.bundleContext;
    }

    public Bundle getBundle(String symbolicName) {
        return this.bundles.get(symbolicName);
    }

    public Map<String, Bundle> getBundlesMap() {
        return this.bundles;
    }

    public ComponentPersistence getComponentPersistence() {
        return this.persistence;
    }

    public synchronized RuntimeContext createContext(Bundle bundle) throws Exception {
        RuntimeContext ctx = this.contexts.get(bundle.getSymbolicName());
        if (ctx == null) {
            ctx = new OSGiRuntimeContext(bundle);
            this.contexts.put(bundle.getSymbolicName(), ctx);
            this.loadComponents(bundle, ctx);
        }
        return ctx;
    }

    public synchronized void destroyContext(Bundle bundle) {
        RuntimeContext ctx = this.contexts.remove(bundle.getSymbolicName());
        if (ctx != null) {
            ctx.destroy();
        }
    }

    public synchronized RuntimeContext getContext(Bundle bundle) {
        return this.contexts.get(bundle.getSymbolicName());
    }

    public synchronized RuntimeContext getContext(String symbolicName) {
        return this.contexts.get(symbolicName);
    }

    @Override
    protected void doStart() throws Exception {
        this.bundleContext.addFrameworkListener((FrameworkListener)this);
        this.loadConfig();
        this.loadComponents(this.bundleContext.getBundle(), this.context);
    }

    @Override
    protected void doStop() throws Exception {
        this.bundleContext.removeFrameworkListener((FrameworkListener)this);
        super.doStop();
        this.context.destroy();
    }

    protected void loadComponents(Bundle bundle, RuntimeContext ctx) throws Exception {
        String list = OSGiRuntimeService.getComponentsList(bundle);
        String name = bundle.getSymbolicName();
        componentDebugLog.debug((Object)("Bundle: " + name + " components: " + list));
        if (list == null) {
            return;
        }
        StringTokenizer tok = new StringTokenizer(list, ", \t\n\r\f");
        while (tok.hasMoreTokens()) {
            String path = tok.nextToken();
            URL url = bundle.getEntry(path);
            componentDebugLog.debug((Object)("Loading component for: " + name + " path: " + path + " url: " + url));
            if (url != null) {
                try {
                    ctx.deploy(url);
                    continue;
                }
                catch (Exception e) {
                    log.error((Object)("Error deploying resource: " + url));
                    Framework.handleDevError(e);
                    throw e;
                }
            }
            String message = "Unknown component '" + path + "' referenced by bundle '" + name + "'";
            log.error((Object)(message + ". Check the MANIFEST.MF"));
            Framework.handleDevError(null);
            this.warnings.add(message);
        }
    }

    public static String getComponentsList(Bundle bundle) {
        return (String)bundle.getHeaders().get("Nuxeo-Component");
    }

    protected void loadConfig() throws Exception {
        File dir;
        Environment env = Environment.getDefault();
        if (env != null) {
            componentDebugLog.info((Object)("Configuration: host application: " + env.getHostApplicationName()));
        } else {
            componentDebugLog.info((Object)"Configuration: no host application");
        }
        File blacklistFile = new File(env.getConfig(), "blacklist");
        if (blacklistFile.isFile()) {
            List lines = FileUtils.readLines((File)blacklistFile);
            HashSet<String> blacklist = new HashSet<String>();
            for (String line : lines) {
                if ((line = line.trim()).length() <= 0) continue;
                blacklist.add(line);
            }
            this.manager.setBlacklist(new HashSet<String>(lines));
        }
        if (env != null && !"JBoss".equals(env.getHostApplicationName()) && (dir = env.getConfig()) != null) {
            log.debug((Object)dir.getAbsolutePath());
            boolean isDirectory = dir.isDirectory();
            componentDebugLog.info((Object)("Configuration: loading from: " + dir.getAbsolutePath() + (isDirectory ? " (is directory)" : "")));
            if (isDirectory) {
                for (String name : dir.list()) {
                    File file;
                    if (name.endsWith("-config.xml") || name.endsWith("-bundle.xml")) {
                        file = new File(dir, name);
                        componentDebugLog.info((Object)("Configuration: deploying to context: " + file.toURL()));
                        this.context.deploy(file.toURL());
                        continue;
                    }
                    if (name.endsWith(".config") || name.endsWith(".ini") || name.endsWith(".properties")) {
                        file = new File(dir, name);
                        componentDebugLog.info((Object)("Configuration: loading properties: " + name));
                        this.loadProperties(file);
                        continue;
                    }
                    componentDebugLog.info((Object)("Configuration: ignoring " + name));
                }
                return;
            }
        }
        String configDir = this.bundleContext.getProperty(PROP_CONFIG_DIR);
        componentDebugLog.info((Object)("Configuration: " + configDir));
        if (configDir == null) {
            return;
        }
        if (configDir.contains(":/")) {
            URL url = new URL(configDir);
            componentDebugLog.info((Object)("Configuration:   loading properties url: " + configDir));
            this.loadProperties(url);
            return;
        }
        File dir2 = new File(configDir);
        if (dir2.isDirectory()) {
            for (String name : dir2.list()) {
                if (name.endsWith("-config.xml") || name.endsWith("-bundle.xml")) {
                    componentDebugLog.info((Object)("Configuration:   postponing config: " + name));
                    continue;
                }
                if (name.endsWith(".config") || name.endsWith(".ini") || name.endsWith(".properties")) {
                    File file = new File(dir2, name);
                    componentDebugLog.info((Object)("Configuration:   loading properties: " + name));
                    this.loadProperties(file);
                    continue;
                }
                componentDebugLog.info((Object)("Configuration:   ignoring: " + name));
            }
        } else {
            File file = new File(configDir);
            componentDebugLog.info((Object)("Configuration:   loading properties: " + file));
            this.loadProperties(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(File file) throws IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
        try {
            this.loadProperties(in);
        }
        finally {
            ((InputStream)in).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadProperties(URL url) throws IOException {
        InputStream in = url.openStream();
        try {
            this.loadProperties(in);
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public void loadProperties(InputStream in) throws IOException {
        Properties props = new Properties();
        props.load(in);
        for (Map.Entry<Object, Object> prop : props.entrySet()) {
            this.properties.put(prop.getKey().toString(), prop.getValue().toString());
        }
    }

    @Override
    public String getProperty(String name, String defValue) {
        String value = this.properties.getProperty(name);
        if (value == null && (value = this.bundleContext.getProperty(name)) == null) {
            return defValue == null ? null : this.expandVars(defValue);
        }
        if (value.startsWith("$") && value.equals("${" + name + "}")) {
            return value;
        }
        return this.expandVars(value);
    }

    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 1) {
            try {
                this.persistence.loadPersistedComponents();
            }
            catch (Exception e) {
                log.error((Object)"Failed to load persisted components", (Throwable)e);
            }
            this.deployFrameworkStartedComponent();
            this.printStatusMessage();
        }
    }

    private void printStatusMessage() {
        String hr = "======================================================================";
        StringBuilder msg = new StringBuilder("Nuxeo EP Started\n");
        msg.append(hr).append("\n= Nuxeo EP Started\n");
        if (!this.warnings.isEmpty()) {
            msg.append(hr).append("\n= Component Loading Errors:\n");
            for (String warning : this.warnings) {
                msg.append("  * ").append(warning).append('\n');
            }
        }
        Map<ComponentName, Set<ComponentName>> pendingRegistrations = this.manager.getPendingRegistrations();
        Collection<ComponentName> activatingRegistrations = this.manager.getActivatingRegistrations();
        msg.append(hr).append("\n= Component Loading Status: Pending: ").append(pendingRegistrations.size()).append(" / Unstarted: ").append(activatingRegistrations.size()).append(" / Total: ").append(this.manager.getRegistrations().size()).append('\n');
        for (Map.Entry<ComponentName, Set<ComponentName>> e : pendingRegistrations.entrySet()) {
            msg.append("  * ").append(e.getKey()).append(" requires ").append(e.getValue()).append('\n');
        }
        for (ComponentName componentName : activatingRegistrations) {
            msg.append("  - ").append(componentName).append('\n');
        }
        msg.append(hr);
        if (this.warnings.isEmpty() && pendingRegistrations.isEmpty() && activatingRegistrations.isEmpty()) {
            log.info((Object)msg);
        } else {
            log.error((Object)msg);
        }
    }

    protected void deployFrameworkStartedComponent() {
        RegistrationInfoImpl ri = new RegistrationInfoImpl(FRAMEWORK_STARTED_COMP);
        ri.setContext(this.context);
        this.manager.register(ri);
    }

    public Bundle findHostBundle(Bundle bundle) {
        String hostId = (String)bundle.getHeaders().get("Fragment-Host");
        componentDebugLog.info((Object)("Looking for host bundle: " + bundle.getSymbolicName() + " host id: " + hostId));
        if (hostId != null) {
            RuntimeContext ctx;
            int p = hostId.indexOf(59);
            if (p > -1) {
                hostId = hostId.substring(0, p);
            }
            if ((ctx = this.contexts.get(hostId)) != null) {
                componentDebugLog.info((Object)("Context was found for host id: " + hostId));
                return ctx.getBundle();
            }
            componentDebugLog.info((Object)("No context found for host id: " + hostId));
        }
        return null;
    }

    @Override
    public File getBundleFile(Bundle bundle) {
        File file;
        String location = bundle.getLocation();
        String vendor = Framework.getProperty("org.osgi.framework.vendor");
        String name = bundle.getSymbolicName();
        if ("Eclipse".equals(vendor)) {
            componentDebugLog.debug((Object)("getBundleFile (Eclipse): " + name + "->" + location));
            if (location.endsWith("/")) {
                location = location.substring(0, location.length() - 1);
            }
            if (location.startsWith("update@")) {
                location = location.substring("update@".length());
            } else if (location.startsWith("initial@reference:file:")) {
                location = location.substring("initial@reference:file:".length());
            }
            file = new File(location);
        } else {
            if (location.startsWith("file:")) {
                try {
                    file = FileUtils.urlToFile((String)location);
                }
                catch (Exception e) {
                    componentDebugLog.error((Object)("getBundleFile: Unable to create  for bundle: " + name + " as URI: " + location));
                    return null;
                }
            }
            try {
                file = new File(location);
            }
            catch (Exception e) {
                componentDebugLog.error((Object)("getBundleFile: Unable to create  for bundle: " + name + " as file: " + location));
                return null;
            }
        }
        if (file != null && file.exists()) {
            componentDebugLog.debug((Object)("getBundleFile: " + name + " bound to file: " + file));
            return file;
        }
        componentDebugLog.debug((Object)("getBundleFile: " + name + " cannot bind to nonexistent file: " + file));
        return null;
    }
}

