/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.runtime.service.proxy;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodInvocation
implements Serializable {
    private static final long serialVersionUID = -7847013619148245793L;
    protected transient Method method;

    public MethodInvocation(Method method) {
        this.method = method;
    }

    public Method getMethod() {
        return this.method;
    }

    public Object invoke(Object proxy, Object ... args) throws Throwable {
        return this.method.invoke(proxy, args);
    }

    protected static Class<?> loadClass(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    protected static Class<?> getPrimitiveType(String name) {
        if (name.equals("byte")) {
            return Byte.TYPE;
        }
        if (name.equals("short")) {
            return Short.TYPE;
        }
        if (name.equals("int")) {
            return Integer.TYPE;
        }
        if (name.equals("long")) {
            return Long.TYPE;
        }
        if (name.equals("char")) {
            return Character.TYPE;
        }
        if (name.equals("float")) {
            return Float.TYPE;
        }
        if (name.equals("double")) {
            return Double.TYPE;
        }
        if (name.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (name.equals("void")) {
            return Void.TYPE;
        }
        return null;
    }

    protected Class<?> getType(String name) throws ClassNotFoundException {
        Class<?> p = MethodInvocation.getPrimitiveType(name);
        if (p == null) {
            p = MethodInvocation.loadClass(name);
        }
        return p;
    }

    protected static void writeChars(ObjectOutputStream out, String chars) throws IOException {
        out.writeInt(chars.length());
        out.writeChars(chars);
    }

    protected static String readChars(ObjectInputStream in) throws IOException {
        int len = in.readInt();
        if (len <= 0) {
            return "";
        }
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            chars[i] = in.readChar();
        }
        return new String(chars);
    }

    protected Method readMethod(ObjectInputStream in) throws ClassNotFoundException, IOException {
        Method method;
        Class<?> klass = MethodInvocation.loadClass(MethodInvocation.readChars(in));
        String meth = MethodInvocation.readChars(in);
        try {
            int len = in.readInt();
            if (len > 0) {
                Class[] params = new Class[len];
                for (int i = 0; i < params.length; ++i) {
                    params[i] = this.getType(MethodInvocation.readChars(in));
                }
                method = klass.getMethod(meth, params);
            } else {
                method = klass.getMethod(meth, new Class[0]);
            }
        }
        catch (NoSuchMethodException e) {
            IOException ee = new IOException("No such method: " + meth + " for class " + klass.getName());
            ee.initCause(e);
            throw ee;
        }
        return method;
    }

    protected void writeMethod(ObjectOutputStream out, Method method) throws IOException {
        MethodInvocation.writeChars(out, method.getDeclaringClass().getName());
        MethodInvocation.writeChars(out, method.getName());
        Class<?>[] params = method.getParameterTypes();
        if (params.length > 0) {
            out.writeInt(params.length);
            for (Class<?> param : params) {
                MethodInvocation.writeChars(out, param.getName());
            }
        } else {
            out.writeInt(0);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.writeMethod(out, this.method);
    }

    private void readObject(ObjectInputStream in) throws ClassNotFoundException, IOException {
        in.defaultReadObject();
        this.method = this.readMethod(in);
    }
}

