/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.server.resteasy;

import java.lang.reflect.Method;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;
import javax.transaction.UserTransaction;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.resteasy.core.ResourceMethod;
import org.jboss.resteasy.core.interception.ResourceMethodContext;
import org.jboss.resteasy.core.interception.ResourceMethodInterceptor;
import org.jboss.resteasy.spi.ApplicationException;
import org.jboss.resteasy.spi.Failure;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class TransactionInterceptor
implements ResourceMethodInterceptor {
    private static final Log log = LogFactory.getLog(TransactionInterceptor.class);
    public boolean txDisabled = false;

    public boolean accepted(ResourceMethod method) {
        return null != method.getMethod().getAnnotation(TransactionAttribute.class);
    }

    public Response invoke(ResourceMethodContext ctx) throws Failure, ApplicationException, WebApplicationException {
        UserTransaction utx;
        Method m;
        TransactionAttribute txanno;
        Object target = ctx.getTarget();
        if (!this.txDisabled && target instanceof Resource && (txanno = (m = ctx.getMethod().getMethod()).getAnnotation(TransactionAttribute.class)) != null && (utx = this.getUserTransaction()) != null) {
            TransactionAttributeType type = txanno.value();
            if (type == TransactionAttributeType.REQUIRED) {
                return this.invoke(ctx, utx, this.safeBeginTransaction(utx));
            }
            if (type == TransactionAttributeType.REQUIRES_NEW) {
                this.safeBeginNewTransaction(utx);
                return this.invoke(ctx, utx, false);
            }
            if (type == TransactionAttributeType.SUPPORTS) {
                return this.invoke(ctx, utx, true);
            }
        }
        return ctx.proceed();
    }

    protected Response invoke(ResourceMethodContext ctx, UserTransaction utx, boolean isManagingTx) throws Failure, ApplicationException, WebApplicationException {
        try {
            Response resp = ctx.proceed();
            if (isManagingTx) {
                utx.commit();
            }
            return resp;
        }
        catch (WebApplicationException e) {
            this.safeRollback(utx, isManagingTx);
            throw e;
        }
        catch (ApplicationException e) {
            this.safeRollback(utx, isManagingTx);
            throw e;
        }
        catch (Failure e) {
            this.safeRollback(utx, isManagingTx);
            throw e;
        }
        catch (Throwable t) {
            this.safeRollback(utx, isManagingTx);
            throw WebException.wrap((Throwable)t);
        }
    }

    protected void safeRollback(UserTransaction utx, boolean isManagingTx) throws WebException {
        try {
            if (isManagingTx) {
                utx.rollback();
            } else {
                utx.setRollbackOnly();
            }
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to rollback tx", (Throwable)e);
        }
    }

    protected boolean safeBeginTransaction(UserTransaction utx) throws WebException {
        try {
            if (utx.getStatus() == 0) {
                return false;
            }
            utx.begin();
            return true;
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to begin tx", (Throwable)e);
        }
    }

    protected void safeBeginNewTransaction(UserTransaction utx) throws WebException {
        try {
            utx.begin();
        }
        catch (Exception e) {
            throw WebException.wrap((String)"Failed to begin tx", (Throwable)e);
        }
    }

    protected final UserTransaction getUserTransaction() {
        try {
            return TransactionHelper.lookupUserTransaction();
        }
        catch (Throwable e) {
            log.error((Object)"Failed to get user transaction, disabling Tx support", e);
            this.txDisabled = true;
            return null;
        }
    }
}

