/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ec.placeful;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.persistence.HibernateConfiguration;
import org.nuxeo.ecm.core.persistence.HibernateConfigurator;
import org.nuxeo.ecm.core.persistence.PersistenceProvider;
import org.nuxeo.ecm.core.persistence.PersistenceProviderFactory;
import org.nuxeo.ecm.platform.ec.placeful.Annotation;
import org.nuxeo.ecm.platform.ec.placeful.AnnotationDescriptor;
import org.nuxeo.ecm.platform.ec.placeful.interfaces.PlacefulService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlacefulServiceImpl
extends DefaultComponent
implements PlacefulService {
    protected final Map<String, String> registry = new HashMap<String, String>();
    protected static final Log log = LogFactory.getLog(PlacefulServiceImpl.class);
    protected PersistenceProvider persistenceProvider;
    protected HibernateConfiguration hibernateConfiguration;

    public PersistenceProvider getOrCreatePersistenceProvider() {
        if (this.persistenceProvider != null) {
            return this.persistenceProvider;
        }
        PersistenceProviderFactory persistenceProviderFactory = (PersistenceProviderFactory)Framework.getLocalService(PersistenceProviderFactory.class);
        this.persistenceProvider = persistenceProviderFactory.newProvider("nxplaceful");
        return this.persistenceProvider;
    }

    public HibernateConfiguration getOrCreateHibernateConfiguration() {
        if (this.hibernateConfiguration != null) {
            return this.hibernateConfiguration;
        }
        HibernateConfigurator hibernateConfigurator = (HibernateConfigurator)Framework.getLocalService(HibernateConfigurator.class);
        this.hibernateConfiguration = hibernateConfigurator.getHibernateConfiguration("nxplaceful");
        return this.hibernateConfiguration;
    }

    protected void deactivatePersistenceProvider() {
        if (this.persistenceProvider == null) {
            return;
        }
        this.persistenceProvider.closePersistenceUnit();
        this.persistenceProvider = null;
    }

    public void deactivate(ComponentContext context) throws Exception {
        this.deactivatePersistenceProvider();
        this.registry.clear();
        super.deactivate(context);
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if ("annotations".equals(extensionPoint)) {
            this.registerAnnotations((AnnotationDescriptor)contribution);
        }
    }

    protected void registerAnnotations(AnnotationDescriptor contribution) {
        HibernateConfiguration config = this.getOrCreateHibernateConfiguration();
        for (Class<? extends Annotation> annotationClass : contribution.annotationClasses) {
            String canonicalName = annotationClass.getCanonicalName();
            String unqualifiedName = canonicalName.substring(canonicalName.lastIndexOf(46) + 1);
            this.registry.put(unqualifiedName, annotationClass.getCanonicalName());
            config.addAnnotedClass(annotationClass);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) throws Exception {
        if (extensionPoint.equals("annotations")) {
            this.unregisterAnnotations((AnnotationDescriptor)contribution);
        }
    }

    protected void unregisterAnnotations(AnnotationDescriptor contribution) {
        HibernateConfiguration config = this.getOrCreateHibernateConfiguration();
        for (Class<? extends Annotation> annotationClass : contribution.annotationClasses) {
            String canonicalName = annotationClass.getCanonicalName();
            String unqualifiedName = canonicalName.substring(canonicalName.lastIndexOf(46) + 1);
            this.registry.remove(unqualifiedName);
            config.removeAnnotedClass(annotationClass);
        }
    }

    public Map<String, String> getAnnotationRegistry() {
        return Collections.unmodifiableMap(this.registry);
    }

    public static String getShortName(String className) {
        return className.substring(className.lastIndexOf(46) + 1);
    }

    public Annotation getAnnotation(EntityManager em, String id, String name) {
        String className = this.registry.get(name);
        String shortClassName = PlacefulServiceImpl.getShortName(className);
        Query query = em.createQuery("FROM " + shortClassName + " WHERE id=:id");
        query.setParameter("id", (Object)id);
        return (Annotation)query.getSingleResult();
    }

    public List<Annotation> getAllAnnotations(EntityManager em, String name) {
        String className = this.registry.get(name);
        String shortClassName = PlacefulServiceImpl.getShortName(className);
        Query query = em.createQuery("FROM " + shortClassName);
        return query.getResultList();
    }

    public List<Annotation> getAllAnnotations(final String name) {
        try {
            return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<Annotation>>(){

                public List<Annotation> runWith(EntityManager em) {
                    return PlacefulServiceImpl.this.getAllAnnotations(em, name);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public Annotation getAnnotation(final String uuid, final String name) {
        try {
            return (Annotation)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<Annotation>(){

                public Annotation runWith(EntityManager em) {
                    return PlacefulServiceImpl.this.getAnnotation(em, uuid, name);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public List<Annotation> getAnnotationListByParamMap(EntityManager em, Map<String, Object> paramMap, String name) {
        String className = this.registry.get(name);
        if (className == null) {
            log.warn((Object)("No placeful configuration registred for " + name));
            return new ArrayList<Annotation>();
        }
        String shortClassName = PlacefulServiceImpl.getShortName(className);
        StringBuilder queryString = new StringBuilder("FROM " + shortClassName);
        if (paramMap != null && !paramMap.isEmpty()) {
            queryString.append(" WHERE ");
            int size = paramMap.size();
            int index = 1;
            for (String key : paramMap.keySet()) {
                queryString.append(key + "=:" + key);
                if (index != size) {
                    queryString.append(" and ");
                }
                ++index;
            }
        }
        Query query = em.createQuery(queryString.toString());
        if (paramMap != null && !paramMap.isEmpty()) {
            for (String key : paramMap.keySet()) {
                query.setParameter(key, paramMap.get(key));
            }
        }
        return query.getResultList();
    }

    public List<Annotation> getAnnotationListByParamMap(final Map<String, Object> paramMap, final String name) {
        try {
            return (List)this.getOrCreatePersistenceProvider().run(Boolean.valueOf(false), (PersistenceProvider.RunCallback)new PersistenceProvider.RunCallback<List<Annotation>>(){

                public List<Annotation> runWith(EntityManager em) {
                    return PlacefulServiceImpl.this.getAnnotationListByParamMap(em, paramMap, name);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void removeAnnotationListByParamMap(EntityManager em, Map<String, Object> paramMap, String name) {
        List<Annotation> annotationsToRemove = this.getAnnotationListByParamMap(em, paramMap, name);
        if (annotationsToRemove != null && !annotationsToRemove.isEmpty()) {
            for (Annotation anno : annotationsToRemove) {
                if (anno == null) continue;
                em.remove((Object)anno);
            }
        }
    }

    public void removeAnnotationListByParamMap(final Map<String, Object> paramMap, final String name) {
        try {
            this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    PlacefulServiceImpl.this.removeAnnotationListByParamMap(em, paramMap, name);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void setAnnotation(EntityManager em, Annotation annotation) {
        em.persist((Object)annotation);
    }

    public void setAnnotation(final Annotation annotation) {
        try {
            this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    PlacefulServiceImpl.this.setAnnotation(em, annotation);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    public void removeAnnotation(EntityManager em, Annotation annotation) {
        em.remove((Object)annotation);
    }

    public void removeAnnotation(final Annotation annotation) {
        try {
            this.getOrCreatePersistenceProvider().run(Boolean.valueOf(true), new PersistenceProvider.RunVoid(){

                public void runWith(EntityManager em) {
                    PlacefulServiceImpl.this.removeAnnotation(em, annotation);
                }
            });
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }
}

