/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.admin.management;

import java.io.File;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.core.Response;
import org.nuxeo.common.utils.FileUtils;
import org.nuxeo.ecm.webengine.WebEngine;
import org.nuxeo.ecm.webengine.WebException;

public class FileResource {
    protected File file;
    protected boolean isReadOnly;

    public FileResource(File file) {
        this(file, false);
    }

    public FileResource(File file, boolean isReadOnly) {
        this.file = file;
        this.isReadOnly = isReadOnly;
    }

    @GET
    public Response get() {
        if (this.file.isDirectory()) {
            return Response.status((int)404).build();
        }
        if (!this.file.isFile()) {
            return Response.status((int)404).build();
        }
        String name = this.file.getName();
        int p = name.lastIndexOf(46);
        if (p > -1) {
            String mime = WebEngine.getActiveContext().getEngine().getMimeType(name.substring(p + 1));
            if (mime == null && name.endsWith(".xsd")) {
                mime = "text/xml";
            }
            return Response.ok((Object)this.file).type(mime).build();
        }
        return Response.ok((Object)this.file).type("application/octet-stream").build();
    }

    @DELETE
    public Response deleteFile() {
        if (this.isReadOnly) {
            return Response.status((int)403).build();
        }
        if (!this.file.isFile()) {
            return Response.status((int)404).build();
        }
        this.file.delete();
        return Response.ok().build();
    }

    @PUT
    public Response updateFile() {
        if (this.isReadOnly) {
            return Response.status((int)403).build();
        }
        if (!this.file.isFile()) {
            return Response.status((int)404).build();
        }
        HttpServletRequest req = WebEngine.getActiveContext().getRequest();
        try {
            FileUtils.copyToFile((InputStream)req.getInputStream(), (File)this.file);
            return Response.ok().build();
        }
        catch (Exception e) {
            throw WebException.wrap((Throwable)e);
        }
    }
}

