/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model;

import com.allen_sauer.gwt.log.client.Log;
import java.util.ArrayList;
import java.util.List;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingInfo;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingInfoCallback;
import org.nuxeo.ecm.platform.pictures.tiles.gwt.client.model.TilingModelListener;

public class TilingModel {
    private TilingInfo tilingInfo;
    private int totalWidth;
    private int totalHeight;
    private int viewAreaTop;
    private int viewAreaLeft;
    private int viewAreaWidth;
    private int viewAreaHeight;
    private int maxLeft;
    private int maxTop;
    private double defaultZoom;
    private int oldXToCenterOn = 0;
    private int oldYToCenterOn = 0;
    private double oldZoom = 1.0;
    private List<TilingModelListener> listeners = new ArrayList<TilingModelListener>();
    private TilingInfoCallback tilingInfoCallback = new TilingInfoCallback(){

        public void tilingInfoUpdated() {
            TilingModel.this.updateModel();
            int x = (int)Math.round((double)TilingModel.this.oldXToCenterOn * TilingModel.this.getCurrentZoom() / TilingModel.this.oldZoom);
            int y = (int)Math.round((double)TilingModel.this.oldYToCenterOn * TilingModel.this.getCurrentZoom() / TilingModel.this.oldZoom);
            Log.debug((String)("center on: x=" + x + ", y=" + y));
            TilingModel.this.centerOn(x, y, false);
            TilingModel.this.fireEvent(TilingModelEvent.TILING_INFO_UPDATED);
        }
    };

    public TilingModel(TilingInfo ti, int viewAreaWidth, int viewAreaHeight, double defaultZoom) {
        this.tilingInfo = ti;
        this.defaultZoom = defaultZoom;
        this.viewAreaWidth = viewAreaWidth;
        this.viewAreaHeight = viewAreaHeight;
        this.viewAreaLeft = 0;
        this.viewAreaTop = 0;
        this.updateModel();
    }

    public void notifyListeners() {
        this.fireEvent(TilingModelEvent.TILING_INFO_UPDATED);
    }

    private void updateModel() {
        this.totalWidth = (int)Math.round((double)this.tilingInfo.getOriginalImageWidth() * this.getCurrentZoom());
        this.totalHeight = (int)Math.round((double)this.tilingInfo.getOriginalImageHeight() * this.getCurrentZoom());
        this.maxLeft = this.totalWidth - this.viewAreaWidth;
        this.maxTop = this.totalHeight - this.viewAreaHeight;
    }

    public void move(int x, int y, boolean fireEvent) {
        this.viewAreaLeft += x;
        this.viewAreaTop += y;
        this.ensureCorrectValues();
        if (fireEvent) {
            this.fireEvent(TilingModelEvent.MOVE_EVENT);
        }
    }

    public void move(int x, int y) {
        this.move(x, y, true);
    }

    public void resetView() {
        this.viewAreaTop = 0;
        this.viewAreaLeft = 0;
    }

    public void setLocation(int left, int top, boolean fireEvent) {
        this.viewAreaLeft = left;
        this.viewAreaTop = top;
        this.ensureCorrectValues();
        if (fireEvent) {
            this.fireEvent(TilingModelEvent.MOVE_EVENT);
        }
    }

    public void setLocation(int left, int top) {
        this.setLocation(left, top, true);
    }

    public void centerOn(int x, int y, boolean fireEvent) {
        this.viewAreaLeft = x - this.viewAreaWidth / 2;
        this.viewAreaTop = y - this.viewAreaHeight / 2;
        Log.debug((String)("viewAreaLeft= " + this.viewAreaLeft + " viewAreaTop= " + this.viewAreaTop));
        this.ensureCorrectValues();
        if (fireEvent) {
            this.fireEvent(TilingModelEvent.MOVE_EVENT);
        }
    }

    public void centerOn(int x, int y) {
        this.centerOn(x, y, true);
    }

    private void ensureCorrectValues() {
        if (this.viewAreaLeft > this.maxLeft) {
            this.viewAreaLeft = this.maxLeft;
        }
        if (this.viewAreaTop > this.maxTop) {
            this.viewAreaTop = this.maxTop;
        }
        if (this.viewAreaLeft < 0) {
            this.viewAreaLeft = 0;
        }
        if (this.viewAreaTop < 0) {
            this.viewAreaTop = 0;
        }
    }

    public void zoomIn() {
        this.tilingInfo.setMaxTiles(this.tilingInfo.getMaxTiles() * 2);
        this.saveOldCoord();
        this.tilingInfo.updateTilingInfo(this.tilingInfoCallback);
    }

    public void zoomOut() {
        if (this.getCurrentZoom() <= this.defaultZoom) {
            return;
        }
        this.tilingInfo.setMaxTiles(this.tilingInfo.getMaxTiles() / 2);
        this.saveOldCoord();
        this.tilingInfo.updateTilingInfo(this.tilingInfoCallback);
    }

    private void saveOldCoord() {
        this.oldZoom = this.getCurrentZoom();
        this.oldXToCenterOn = this.viewAreaLeft + this.viewAreaWidth / 2;
        this.oldYToCenterOn = this.viewAreaTop + this.viewAreaHeight / 2;
    }

    public void addListener(TilingModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(TilingModelListener listener) {
        this.listeners.remove(listener);
    }

    private void fireEvent(TilingModelEvent event) {
        for (TilingModelListener l : this.listeners) {
            l.onModelChange(event, this);
        }
    }

    public int getTotalWidth() {
        return this.totalWidth;
    }

    public int getTotalHeight() {
        return this.totalHeight;
    }

    public int getViewAreaTop() {
        return this.viewAreaTop;
    }

    public int getViewAreaLeft() {
        return this.viewAreaLeft;
    }

    public int getViewAreaWidth() {
        return this.viewAreaWidth;
    }

    public int getViewAreaHeight() {
        return this.viewAreaHeight;
    }

    public int getTileWidth() {
        return this.tilingInfo.getTileWidth();
    }

    public int getTileHeight() {
        return this.tilingInfo.getTileHeight();
    }

    public int getWidthInTiles() {
        return this.tilingInfo.getNbXTiles();
    }

    public int getHeightInTiles() {
        return this.tilingInfo.getNbYTiles();
    }

    public String getBaseUrl() {
        return this.tilingInfo.getBaseUrl();
    }

    public double getCurrentZoom() {
        return this.tilingInfo.getZoom();
    }

    public long getLastModificationDate() {
        return this.tilingInfo.getLastModificationDate();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TilingModelEvent {
        MOVE_EVENT,
        TILING_INFO_UPDATED;

    }
}

